/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.menuitem;

import gongqi.designer.utils.GOTHelper;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.Entity;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MenuItem
extends Entity {
    @Override
    public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML) {
        if (propertyName.equals("RefObject")) {
            ArrayList<String> array = new ArrayList<String>();
            List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
            List<Object> forms = new ArrayList();
            if (sourceTypePro.get(0).attributeValue("Value").equals("Form")) {
                forms = GotXmlDto.getInstance().currentElements("Forms");
            }
            for (Element form : forms) {
                array.add(form.attributeValue("name"));
            }
            return array;
        }
        return super.getPropertyItemEditorArray(propertyName, "", null);
    }

    @Override
    public void doAfterPropertyModified(Element property, String ... args) {
        List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
        if (property.elementText("Name").equals("Source")) {
            String source = sourceTypePro.get(0).elementText("Value");
            String formName = property.elementText("Value");
            List<Element> form = null;
            if (source.equals("Form")) {
                form = GotXmlDto.getInstance().currentElements("Forms", "name", formName);
            } else if (source.equals("Report")) {
                form = GotXmlDto.getInstance().currentElements("Reports", "name", formName);
            }
            if (form != null && form.size() > 0) {
                property.addAttribute("refentityid", form.get(0).attributeValue("id"));
            } else if (property.attribute("refentityid") != null) {
                property.remove(property.attribute("refentityid"));
            }
        }
        super.doAfterPropertyModified(property, args);
    }

    @Override
    protected void doPropertyTrigger(Element property) {
        super.doPropertyTrigger(property);
        if (property.elementText("Name").equals("Source")) {
            Element sourcePro = GOTHelper.getProperty((Element)this.xml, (String)"SourceType");
            String source = sourcePro.elementText("Value");
            if (source.equals("Form")) {
                this.xml.addAttribute("name", property.elementText("Value"));
            } else if (!source.equals("Html")) {
                this.xml.addAttribute("name", String.valueOf(source) + "_" + property.elementText("Value"));
            }
        }
        this.setEntityUniqueName();
    }

    private void setEntityUniqueName() {
        String origName;
        Element outer = this.xml.getParent();
        String newName = origName = this.xml.attributeValue("name");
        int i = 1;
        String xpath = "MenuItem[@name='" + newName + "']";
        if (MenuItem.checkParentNodes(outer)) {
            outer = GotXmlDto.getInstance().getCurrentElements("MenuItems");
        }
        List elements = outer.selectNodes(xpath);
        while (elements.size() - i > 0) {
            newName = String.valueOf(origName) + i;
            this.xml.addAttribute("name", newName);
            ++i;
        }
        this.xml.addAttribute("name", newName);
    }

    @Override
    public void doAfterDragDroped() {
        List<Element> refObjectPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
        this.doAfterPropertyModified(refObjectPro.get(0), new String[0]);
        String id = "";
        try {
            id = LoadXmlCore.gotServices.getEntityId(EntityType.MenuItem);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            GOTMessageDialog.alert(e);
        }
        this.xml.addAttribute("id", id);
    }

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        NodeGOT node = super.doAccpDragNew("MenuItem", "");
        this.doAccpDragNewAfter(src, node.xml);
        return node;
    }

    private void doAccpDragNewAfter(Element src, Element node) {
        String srcName = src.getName();
        GOTXMLHelper.setProperty(node, "SourceType", srcName, true);
        GOTXMLHelper.setProperty(node, "Source", src.attributeValue("name"), true);
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "parent";
    }

    @Override
    protected String validateProperties(Element nodeBeValidated) {
        Element property = GOTHelper.getProperty((Element)nodeBeValidated, (String)"Source");
        if (property.attribute("refentityid") != null) {
            String subForm;
            Element sourcePro = GOTHelper.getProperty((Element)nodeBeValidated, (String)"SourceType");
            String source = sourcePro.elementText("Value");
            String entityId = property.attributeValue("refentityid");
            Element entities = null;
            if (source.equals("Form")) {
                entities = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", entityId);
            }
            if (entities == null) {
                return "RefObject \u5173\u8054\u65e0\u6548";
            }
            if (source.equals("Form") && "SubForm".equals(subForm = GOTHelp.getPPAttValue(entities, "Name", "FormType"))) {
                return "SubForm\u5c5e\u6027\u4e3atrue\u7684Form\uff0c\u4e0d\u80fd\u4fdd\u5b58\u4e3aMenuItem";
            }
        }
        return Macros.INFO_TRUE;
    }

    @Override
    public String validateAccpDragNew(Element srcItem) {
        String formType;
        String qName;
        if (srcItem != null && "Form".equals(qName = srcItem.getName()) && "Lookup".equals(formType = GOTHelper.getPropertyValue((Element)srcItem, (String)"FormType"))) {
            return "FormType\u5c5e\u6027\u4e3aLookup\u7684Form\u4e0d\u5141\u8bb8\u88ab\u62d6\u52a8\u5230MenuItem";
        }
        return "true";
    }
}

