/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.util;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.utils.Images;
import info.gongqi.got.util.GOTUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ComposeIMG {
    public static String TABLE = "Table";
    public static String TABLEFIELD = "TableField";
    public static String TABLEFIELDGROUPITEM = "TableFieldGroupItem";
    public static String FORM = "Form";
    public static String FORMDATASOURCEFIELD = "FormDataSourceField";
    public static String DATATYPE = "DataType";
    public static String ENUM = "Enum";
    public static String MENU = "Menu";
    public static String MENUITEM = "MenuItem";
    public static String REPORTFIELD = "ReportField";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_ENUM = "Enum";
    public static final String TYPE_LONG = "Long";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_DECIMAL = "Decimal";
    public static final String TYPE_COMPONENT = "Component";
    public static final String TYPE_BOOLEAN = "Boolean";
    protected static Boolean currentLayer = false;
    protected static Boolean locked = false;
    protected static Boolean invisible = false;
    protected static Boolean deprecated = false;
    protected static Boolean unsaved = false;
    protected static Boolean baseTypeImg = false;
    protected static String data_type;
    protected static String data_type_img_name;
    protected static String layer_currentLayer;
    protected static String layer_deprecated;
    protected static String layer_invisible;
    protected static String layer_locked;
    protected static String layer_unsaved;
    public static Map<String, Image> imgMap;

    static {
        layer_currentLayer = "/layer_currentLayer.png";
        layer_deprecated = "/layer_deprecated.png";
        layer_invisible = "/layer_invisible.png";
        layer_locked = "/layer_locked.png";
        layer_unsaved = "/layer_unsaved.png";
        imgMap = new HashMap<String, Image>();
    }

    public static Image drawImg(Element node) {
        Image image = null;
        baseTypeImg = false;
        String imgName = ComposeIMG.treeItemImgName(node);
        ComposeIMG.choiceRes(node);
        if (!(currentLayer.booleanValue() || locked.booleanValue() || invisible.booleanValue() || deprecated.booleanValue() || unsaved.booleanValue() || baseTypeImg.booleanValue())) {
            image = ComposeIMG.drawImgDef(node);
            return image;
        }
        String mapKey = String.valueOf(locked.toString()) + invisible.toString() + currentLayer.toString() + deprecated.toString() + unsaved.toString() + imgName + node.getName();
        if (data_type_img_name != null && !"".equals(data_type_img_name)) {
            mapKey = String.valueOf(mapKey) + data_type_img_name;
        }
        if (imgMap.get(mapKey) != null) {
            baseTypeImg = false;
            locked = false;
            invisible = false;
            currentLayer = false;
            deprecated = false;
            unsaved = false;
            return imgMap.get(mapKey);
        }
        InputStream inStream = Images.getIconInputStream(String.valueOf(imgName) + ".png");
        if (inStream == null) {
            System.out.println("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u56fe\u6807\uff0cpath:" + imgName + ".png");
            return image;
        }
        try {
            InputStream inputStream;
            int y;
            int x;
            Graphics2D graphics2d;
            BufferedImage buf_locked;
            BufferedImage buf = ImageIO.read(inStream);
            if (baseTypeImg.booleanValue() && data_type_img_name != null && !"".equals(data_type_img_name)) {
                inStream = Images.getIconInputStream(String.valueOf(data_type_img_name) + ".png");
                if (inStream == null) {
                    System.out.println(String.valueOf(data_type_img_name) + ".png");
                } else {
                    buf_locked = ImageIO.read(inStream);
                    graphics2d = buf.createGraphics();
                    x = buf.getWidth() - buf_locked.getWidth();
                    y = buf.getHeight() - buf_locked.getHeight();
                    graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                    graphics2d.dispose();
                    baseTypeImg = false;
                }
            }
            if (locked.booleanValue()) {
                inStream = Images.getImageInputStream(layer_locked);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                locked = false;
            }
            if (invisible.booleanValue()) {
                inStream = Images.getImageInputStream(layer_invisible);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                graphics2d.drawImage(buf_locked, x, 0, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                invisible = false;
            }
            if (currentLayer.booleanValue()) {
                inStream = Images.getImageInputStream(layer_currentLayer);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                int y2 = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, 0, y2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                currentLayer = false;
            }
            if (deprecated.booleanValue()) {
                inStream = Images.getImageInputStream(layer_deprecated);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2, y / 2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                deprecated = false;
            }
            if (unsaved.booleanValue()) {
                inStream = Images.getImageInputStream(layer_unsaved);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2 - 1, y / 2 - 1, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                unsaved = false;
            }
            if ((inputStream = ComposeIMG.bufferedImageToInputStream(buf)) != null) {
                image = ComposeIMG.getImage(inputStream);
            }
            inStream.close();
            imgMap.put(mapKey, image);
        }
        catch (IOException e) {
            Logger.getLogger(ComposeIMG.class).error((Object)"", (Throwable)e);
        }
        return image;
    }

    public static Image drawImgDef(Element node) {
        Image image = null;
        String imgName = ComposeIMG.treeItemImgName(node);
        if ("".equals(imgName)) {
            return image;
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        imgMap.put(imgName, image);
        return image;
    }

    public static Image drawImgDef(String imgName) {
        Image image = null;
        if ("".equals(imgName) || imgName.startsWith("Node_")) {
            imgName = "Default";
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        if (image == null) {
            image = Images.getIcon("Default.png");
        }
        imgMap.put(imgName, image);
        return image;
    }

    private static String treeItemImgName(Element node) {
        Attribute attribute;
        String name = node.getName();
        String imgName = "";
        if (!"".endsWith(name) && name != null) {
            imgName = name;
            if (!(name.equals(DATATYPE) || name.equals(TABLEFIELD) || name.equals(FORMDATASOURCEFIELD) || name.equals(REPORTFIELD) || (attribute = node.attribute("type")) == null || name.equals(TABLEFIELDGROUPITEM))) {
                imgName = String.valueOf(imgName) + attribute.getText().replace("Editor", "");
                return imgName;
            }
            if (GOTUtil.imgNames.contains(String.valueOf(imgName) + ".png")) {
                return imgName;
            }
        }
        imgName = (attribute = node.attribute("saved")) != null && "0".equals(attribute.getText()) ? "DefaultUnsaved" : "Default";
        return imgName;
    }

    private static void choiceRes(Element node) {
        block35: {
            String nodeName;
            Attribute attribute = node.attribute("nextInnerId");
            if (attribute != null) {
                attribute = node.attribute("createdLayer");
                if (attribute != null && attribute.getText().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                    currentLayer = true;
                }
                if ((attribute = node.attribute("locked")) != null && attribute.getText().equals("true")) {
                    locked = true;
                }
                if ((attribute = node.attribute("visible")) != null && attribute.getText().equals("false")) {
                    invisible = true;
                }
                if ((attribute = node.attribute("deprecated")) != null && attribute.getText().equals("true")) {
                    deprecated = true;
                }
                if ((attribute = node.attribute("saved")) != null && attribute.getText().equals("0")) {
                    unsaved = true;
                }
            }
            if ((attribute = node.attribute("id")) != null && (attribute = node.attribute("createdLayer")).getText().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                currentLayer = true;
            }
            if (!(nodeName = node.getName()).equals(DATATYPE) && !nodeName.equals(TABLEFIELD) && !nodeName.equals(FORMDATASOURCEFIELD) && !nodeName.equals(REPORTFIELD) || (attribute = node.attribute("type")) == null) break block35;
            switch (attribute.getText()) {
                case "Boolean": {
                    data_type_img_name = unsaved == false ? "BooleanType" : "BooleanTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Component": {
                    data_type_img_name = unsaved == false ? "ComponentType" : "ComponentTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Date": {
                    data_type_img_name = unsaved == false ? "DateType" : "DateTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Decimal": {
                    data_type_img_name = unsaved == false ? "DecimalType" : "DecimalTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Enum": {
                    data_type_img_name = unsaved == false ? "EnumType" : "EnumTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Long": {
                    data_type_img_name = unsaved == false ? "LongType" : "LongTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "String": {
                    data_type_img_name = unsaved == false ? "StringType" : "StringTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Time": {
                    data_type_img_name = unsaved == false ? "TimeType" : "TimeTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
            }
        }
    }

    private static InputStream bufferedImageToInputStream(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        ByteArrayInputStream input = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return input;
    }

    private static Image getImage(InputStream stream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData data = new ImageData(stream);
            if (data.transparentPixel > 0) {
                Image image = new Image((Device)display, data, data.getTransparencyMask());
                return image;
            }
            Image image = new Image((Device)display, data);
            return image;
        }
        finally {
            stream.close();
        }
    }
}

