var pivotData;
var rowcolChanging = false;
var numberFormat;
var usFmtPct;
var numDecimals = {};
var refreshExternal;
function Fkey() {
        var WsShell = new ActiveXObject('WScript.Shell')
        WsShell.SendKeys('{F11}');
} 
      //进入全屏
function requestFullScreen() {
      var de = document.documentElement;
      if (de.requestFullscreen) {
          de.requestFullscreen();
	    } else if (de.mozRequestFullScreen) {
	          de.mozRequestFullScreen();
	    } else if (de.webkitRequestFullScreen) {
	         de.webkitRequestFullScreen();
	    }
	    $(".fullscreen").hide();
	    $(".chart").show();
}
 //退出全屏
function exitFullscreen() {
     var de = document;
     if (de.exitFullscreen) {
         de.exitFullscreen();
     } else if (de.mozCancelFullScreen) {
         de.mozCancelFullScreen();
     } else if (de.webkitCancelFullScreen) {
         de.webkitCancelFullScreen();
     }
     $(".fullscreen").show();
     $(".chart").hide();
}
function onlyChart () {
	$("#xia").hide();
	if (document.webkitCancelFullScreen) {
	document.webkitRequestFullScreen();
	}
	$("#midri").append("<img id='exit' src='../pic/functionIcon/close_alt2.png' onclick='exitChart()'style='position:fixed;top:12px;right: 12px;'/>");
	$("#onlyChart").hide();
	$("#closeFullscreen").hide();
}
function exitChart(){
     $("#xia").show();
     $("#exit").remove();
     $("#onlyChart").show();
     $("#closeFullscreen").show();
}
(function() {
	var callWithJQuery,
		indexOf = [].indexOf || function(item) {
			for (var i = 0, l = this.length; i < l; i++) {
				if (i in this && this[i] === item) return i;
			}
			return -1;
		},
		slice = [].slice,
		bind = function(fn, me) {
			return function() {
				return fn.apply(me, arguments);
			};
		},
		hasProp = {}.hasOwnProperty;

	callWithJQuery = function(pivotModule) {
		if (typeof exports === "object" && typeof module === "object") {
			return pivotModule(require("jquery"));
		} else if (typeof define === "function" && define.amd) {
			return define(["jquery"], pivotModule);
		} else {
			return pivotModule(jQuery);
		}
	};

	callWithJQuery(function($) {

		/*
		Utilities
		 */
		var PivotData, addSeparators, aggregatorTemplates, aggregators, dayNamesEn, derivers, getSort, locales, mthNamesEn, naturalSort, pivotTableRenderer, renderers, sortAs, usFmt, usFmtInt, zeroPad;
		addSeparators = function(nStr, thousandsSep, decimalSep) {
			var rgx, x, x1, x2;
			nStr += '';
			x = nStr.split('.');
			x1 = x[0];
			x2 = x.length > 1 ? decimalSep + x[1] : '';
			rgx = /(\d+)(\d{3})/;
			while (rgx.test(x1)) {
				x1 = x1.replace(rgx, '$1' + thousandsSep + '$2');
			}
			return x1 + x2;
		};
		numberFormat = function(opts) {
			var defaults;
			defaults = {
				digitsAfterDecimal: 2,
				scaler: 1,
				thousandsSep: ",",
				decimalSep: ".",
				prefix: "",
				suffix: "",
				showZero: false
			};
			opts = $.extend(defaults, opts);
			return function(x) {
				var result;
				if (isNaN(x) || !isFinite(x)) {
					return "";
				}
				if (x === 0 && !opts.showZero) {
					return "";
				}
				result = addSeparators((opts.scaler * x).toFixed(opts.digitsAfterDecimal), opts.thousandsSep, opts.decimalSep);
				return "" + opts.prefix + result + opts.suffix;
			};
		};
		usFmt = numberFormat();
		usFmtInt = numberFormat({
			digitsAfterDecimal: 0
		});
		usFmtPct = numberFormat({
			digitsAfterDecimal: 1,
			scaler: 100,
			suffix: "%"
		});
		aggregatorTemplates = {
			count: function(formatter) {
				if (formatter == null) {
					formatter = usFmtInt;
				}
				return function() {
					return function(data, rowKey, colKey) {
						return {
							count: 0,
							push: function() {
								return this.count++;
							},
							value: function() {
								return this.count;
							},
							format: formatter
						};
					};
				};
			},
			countUnique: function(formatter) {
				if (formatter == null) {
					formatter = usFmtInt;
				}
				return function(arg) {
					var attr;
					attr = arg[0];
					//var attr = arg;
					return function(data, rowKey, colKey) {
						return {
							uniq: [],
							push: function(record) {
								var ref;
								if (ref = record[attr], indexOf.call(this.uniq, ref) < 0) {
									return this.uniq.push(record[attr]);
								}
							},
							value: function() {
								return this.uniq.length;
							},
							format: formatter,
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			listUnique: function(sep) {
				return function(arg) {
					var attr;
					attr = arg[0];
					return function(data, rowKey, colKey) {
						return {
							uniq: [],
							push: function(record) {
								var ref;
								if (ref = record[attr], indexOf.call(this.uniq, ref) < 0) {
									return this.uniq.push(record[attr]);
								}
							},
							value: function() {
								return this.uniq.join(sep);
							},
							format: function(x) {
								return x;
							},
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			sum: function(formatter) {
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var attr;
					attr = arg[0];
					var number = 2;
					if(numDecimals.hasOwnProperty(attr)){
						number = numDecimals[attr];
						number = parseInt(number);
					}
					return function(data, rowKey, colKey) {
						return {
							//aggregatorField:attr,
							sum: 0,
							push: function(record) {
								if (!isNaN(parseFloat(record[attr]))) {
									return this.sum += parseFloat(record[attr]);
								}
							},
							value: function() {
								return this.sum;
							},
							/*format:function(){
								if(numDecimals.hasOwnProperty(attr))
									numberFormat({digitsAfterDecimal:numDecimals[attr]})
								else
									numberFormat({digitsAfterDecimal:2});
							},*/
							format:numberFormat({digitsAfterDecimal:number}),
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			min: function(formatter) {
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var attr;
					attr = arg[0];
					var number = 2;
					if(numDecimals.hasOwnProperty(attr)){
						number = numDecimals[attr];
						number = parseInt(number);
					}
					return function(data, rowKey, colKey) {
						return {
							val: null,
							push: function(record) {
								var ref, x;
								x = parseFloat(record[attr]);
								if (!isNaN(x)) {
									return this.val = Math.min(x, (ref = this.val) != null ? ref : x);
								}
							},
							value: function() {
								return this.val;
							},
							format:numberFormat({digitsAfterDecimal:number}),
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			max: function(formatter) {
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var attr;
					attr = arg[0];
					var number = 2;
					if(numDecimals.hasOwnProperty(attr)){
						number = numDecimals[attr];
						number = parseInt(number);
					}
					return function(data, rowKey, colKey) {
						return {
							val: null,
							push: function(record) {
								var ref, x;
								x = parseFloat(record[attr]);
								if (!isNaN(x)) {
									return this.val = Math.max(x, (ref = this.val) != null ? ref : x);
								}
							},
							value: function() {
								return this.val;
							},
							format:numberFormat({digitsAfterDecimal:number}),
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			average: function(formatter) {
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var attr;
					attr = arg[0];
					var number = 2;
					if(numDecimals.hasOwnProperty(attr)){
						number = numDecimals[attr];
						number = parseInt(number);
					}
					return function(data, rowKey, colKey) {
						return {
							sum: 0,
							len: 0,
							push: function(record) {
								if (!isNaN(parseFloat(record[attr]))) {
									this.sum += parseFloat(record[attr]);
									return this.len++;
								}
							},
							value: function() {
								return this.sum / this.len;
							},
							format:numberFormat({digitsAfterDecimal:number}),
							numInputs: attr != null ? 0 : 1
						};
					};
				};
			},
			sumOverSum: function(formatter) {
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var denom, num;
					num = arg[0], denom = arg[1];
					return function(data, rowKey, colKey) {
						return {
							sumNum: 0,
							sumDenom: 0,
							push: function(record) {
								if (!isNaN(parseFloat(record[num]))) {
									this.sumNum += parseFloat(record[num]);
								}
								if (!isNaN(parseFloat(record[denom]))) {
									return this.sumDenom += parseFloat(record[denom]);
								}
							},
							value: function() {
								return this.sumNum / this.sumDenom;
							},
							format: formatter,
							numInputs: (num != null) && (denom != null) ? 0 : 2
						};
					};
				};
			},
			sumOverSumBound80: function(upper, formatter) {
				if (upper == null) {
					upper = true;
				}
				if (formatter == null) {
					formatter = usFmt;
				}
				return function(arg) {
					var denom, num;
					num = arg[0], denom = arg[1];
					return function(data, rowKey, colKey) {
						return {
							sumNum: 0,
							sumDenom: 0,
							push: function(record) {
								if (!isNaN(parseFloat(record[num]))) {
									this.sumNum += parseFloat(record[num]);
								}
								if (!isNaN(parseFloat(record[denom]))) {
									return this.sumDenom += parseFloat(record[denom]);
								}
							},
							value: function() {
								var sign;
								sign = upper ? 1 : -1;
								return (0.821187207574908 / this.sumDenom + this.sumNum / this.sumDenom + 1.2815515655446004 * sign * Math.sqrt(0.410593603787454 / (this.sumDenom * this.sumDenom) + (this.sumNum * (1 - this.sumNum / this.sumDenom)) / (this.sumDenom * this.sumDenom))) / (1 + 1.642374415149816 / this.sumDenom);
							},
							format: formatter,
							numInputs: (num != null) && (denom != null) ? 0 : 2
						};
					};
				};
			},
			fractionOf: function(wrapped, type, formatter) {
				if (type == null) {
					type = "total";
				}
				if (formatter == null) {
					formatter = usFmtPct;
				}
				return function() {
					var x;
					var y;
					if (arguments.length < 1) {
						x = [];
						y = 0;
					} else if (arguments.length == 1) {
						x = slice.call(arguments, 0);
					} else {
						x = [arguments[0]], y = arguments[1];
					}
					var number = 2;
					if(x.length>0)
					{
						var attr = x[0];
						if(numDecimals.hasOwnProperty(attr)){
							number = numDecimals[attr];
							number = parseInt(number);
						}
					}
						
					
					/*if(arguments.length>1)
			y = arguments.pop();
		  if(y==undefined)
			y = 0;
          x = 1 <= arguments.length ? slice.call(arguments, 0) : [];*/
					return function(data, rowKey, colKey) {
						return {
							selector: {
								total: [
									[],
									[]
								],
								row: [rowKey, []],
								col: [
									[], colKey
								]
							}[type],
							inner: wrapped.apply(null, x)(data, rowKey, colKey),
							push: function(record) {
								return this.inner.push(record);
							},
							format:numberFormat({digitsAfterDecimal:number,scaler: 100,suffix: "%"}),
							tmpValue:-1,
							value: function() {
								var _arggregators = data.getAggregator.apply(data, this.selector, 1);
								var _tmpValue = this.inner.value() / _arggregators[y].inner.value();
								this.tmpValue = _tmpValue;
								//alert(this.tmpValue);
								return _tmpValue;
							},
							numInputs: wrapped.apply(null, x)().numInputs
						};
					};
				};
			}
		};

		//数据分析算法类型
		aggregators = (function(tpl) {
			return {
				"计数": tpl.count(usFmtInt),
				"合计": tpl.sum(usFmt),
				"平均值": tpl.average(usFmt),
				"最小值": tpl.min(usFmt),
				"最大值": tpl.max(usFmt),
				"合计(百分比)": tpl.fractionOf(tpl.sum(), "total", usFmtPct),
				"按行合计(百分比)": tpl.fractionOf(tpl.sum(), "row", usFmtPct),
				"按列合计(百分比)": tpl.fractionOf(tpl.sum(), "col", usFmtPct),
				"计数(百分比)": tpl.fractionOf(tpl.count(), "total", usFmtPct),
				"按行计数(百分比)": tpl.fractionOf(tpl.count(), "row", usFmtPct),
				"按列计数(百分比)": tpl.fractionOf(tpl.count(), "col", usFmtPct)
			};
		})(aggregatorTemplates);

		renderers = {
			"表格": function(pvtData, opts) {
				return pivotTableRenderer(pvtData, opts);
			},
			"行列转置": function(pvtData, opts) {
				return pivotTableRenderer(pvtData, opts);
			},
			"热图": function(pvtData, opts) {
				return $(pivotTableRenderer(pvtData, opts)).heatmap();
			},
			"行热图": function(pvtData, opts) {
				return $(pivotTableRenderer(pvtData, opts)).heatmap("rowheatmap");
			},
			"列热图": function(pvtData, opts) {
				return $(pivotTableRenderer(pvtData, opts)).heatmap("colheatmap");
			},
			"树形表格":function(){
				return $(treegrid());
			},
			"导出到Excel":function(){
				return $(exportexcel());
			}
		};

		//抛出信息显示定义
		locales = {
			en: {
				aggregators: aggregators,
				renderers: renderers,
				localeStrings: {
					renderError: "An error occurred rendering the PivotTable results.",
					computeError: "An error occurred computing the PivotTable results.",
					uiRenderError: "An error occurred rendering the PivotTable UI.",
					selectAll: "全部选择",
					selectNone: "全部取消",
					tooMany: "(too many to list)",
					filterResults: "过滤条件",
					totals: "合计",
					vs: "vs",
					by: "by"
				}
			}
		};
		//月份常量
		mthNamesEn = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
		//星期常量
		dayNamesEn = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

		//数字进行某种格式操作
		zeroPad = function(number) {
			return ("0" + number).substr(-2, 2);
		};

		derivers = {
			bin: function(col, binWidth) {
				return function(record) {
					return record[col] - record[col] % binWidth;
				};
			},
			dateFormat: function(col, formatString, utcOutput, mthNames, dayNames) {
				var utc;
				if (utcOutput == null) {
					utcOutput = false;
				}
				if (mthNames == null) {
					mthNames = mthNamesEn;
				}
				if (dayNames == null) {
					dayNames = dayNamesEn;
				}
				utc = utcOutput ? "UTC" : "";
				return function(record) {
					var date;
					date = new Date(Date.parse(record[col]));
					if (isNaN(date)) {
						return "";
					}
					return formatString.replace(/%(.)/g, function(m, p) {
						switch (p) {
							case "y":
								return date["get" + utc + "FullYear"]();
							case "m":
								return zeroPad(date["get" + utc + "Month"]() + 1);
							case "n":
								return mthNames[date["get" + utc + "Month"]()];
							case "d":
								return zeroPad(date["get" + utc + "Date"]());
							case "w":
								return dayNames[date["get" + utc + "Day"]()];
							case "x":
								return date["get" + utc + "Day"]();
							case "H":
								return zeroPad(date["get" + utc + "Hours"]());
							case "M":
								return zeroPad(date["get" + utc + "Minutes"]());
							case "S":
								return zeroPad(date["get" + utc + "Seconds"]());
							default:
								return "%" + p;
						}
					});
				};
			}
		};
		naturalSort = (function(_this) {
			return function(as, bs) {
				var a, a1, b, b1, rd, rx, rz;
				rx = /(\d+)|(\D+)/g;
				rd = /\d/;
				rz = /^0/;
				if (typeof as === "number" || typeof bs === "number") {
					if (isNaN(as)) {
						return 1;
					}
					if (isNaN(bs)) {
						return -1;
					}
					return as - bs;
				}
				a = String(as).toLowerCase();
				b = String(bs).toLowerCase();
				if (a === b) {
					return 0;
				}
				if (!(rd.test(a) && rd.test(b))) {
					return (a > b ? 1 : -1);
				}
				a = a.match(rx);
				b = b.match(rx);
				while (a.length && b.length) {
					a1 = a.shift();
					b1 = b.shift();
					if (a1 !== b1) {
						if (rd.test(a1) && rd.test(b1)) {
							return a1.replace(rz, ".0") - b1.replace(rz, ".0");
						} else {
							return (a1 > b1 ? 1 : -1);
						}
					}
				}
				return a.length - b.length;
			};
		})(this);
		sortAs = function(order) {
			var i, mapping, x;
			mapping = {};
			for (i in order) {
				x = order[i];
				mapping[x] = i;
			}
			return function(a, b) {
				if ((mapping[a] != null) && (mapping[b] != null)) {
					return mapping[a] - mapping[b];
				} else if (mapping[a] != null) {
					return -1;
				} else if (mapping[b] != null) {
					return 1;
				} else {
					return naturalSort(a, b);
				}
			};
		};
		getSort = function(sorters, attr) {
			var sort;
			sort = sorters(attr);
			if ($.isFunction(sort)) {
				return sort;
			} else {
				return naturalSort;
			}
		};
		$.pivotUtilities = {
			aggregatorTemplates: aggregatorTemplates,
			aggregators: aggregators,
			renderers: renderers,
			derivers: derivers,
			locales: locales,
			naturalSort: naturalSort,
			numberFormat: numberFormat,
			sortAs: sortAs
		};

		/*
		Data Model class
		 */
		//写入数据
		//更改参数配置时执行
		//第一次初始化的时候也会执行一次
		PivotData = (function() {
			function PivotData(input, opts, toChinese) {
				this.getAggregator = bind(this.getAggregator, this);
				this.getRowKeys = bind(this.getRowKeys, this);
				this.getColKeys = bind(this.getColKeys, this);
				this.getAllKeys = bind(this.getAllKeys, this);
				this.sortKeys = bind(this.sortKeys, this);
				this.arrSort = bind(this.arrSort, this);
				this.aggregators = opts.aggregators;
				this.aggregatorNames = opts.aggregatorNames;
				this.colAttrs = opts.cols;
				this.rowAttrs = opts.rows;
				
				this.allAttrs = this.rowAttrs.concat(this.colAttrs);
				
				this.valAttrs = opts.vals;
				this.sorters = opts.sorters;
				this.toChinese = toChinese;
				this.tree = {};
				this.rowKeys = [];
				this.colKeys = [];
				
				this.allKeys = [];
				
				this.rowTotals = {};
				this.colTotals = {};
				this.allTotals = [];
				for (var i in this.aggregators) {
					this.allTotals.push(this.aggregators[i](this, [], []));
				}
				this.sorted = false;
				this.allsorted = false;
				PivotData.forEachRecord(input, opts.derivedAttributes, (function(_this) {
					return function(record) {
						if (opts.filter(record)) {
							return _this.processRecord(record);
						}
					};
				})(this));
			}

			PivotData.forEachRecord = function(input, derivedAttributes, f) {

				var addRecord, compactRecord, i, j, k, l, len1, record, ref, results, results1, tblCols;
				if ($.isEmptyObject(derivedAttributes)) {
					addRecord = f;
				} else {
					addRecord = function(record) {
						var k, ref, v;
						for (k in derivedAttributes) {
							v = derivedAttributes[k];
							record[k] = (ref = v(record)) != null ? ref : record[k];
						}
						return f(record);
					};
				}
				if ($.isFunction(input)) {
					return input(addRecord);
				} else if ($.isArray(input)) {
					if ($.isArray(input[0])) {
						results = [];
						for (i in input) {
							if (!hasProp.call(input, i)) continue;
							compactRecord = input[i];
							if (!(i > 0)) {
								continue;
							}
							record = {};
							ref = input[0];
							for (j in ref) {
								if (!hasProp.call(ref, j)) continue;
								k = ref[j];
								record[k] = compactRecord[j];
							}
							results.push(addRecord(record));
						}
						return results;
					} else {
						results1 = [];
						for (l = 0, len1 = input.length; l < len1; l++) {
							record = input[l];
							results1.push(addRecord(record));
						}
						return results1;
					}
				} else if (input instanceof jQuery) {
					tblCols = [];
					$("thead > tr > th", input).each(function(i) {
						return tblCols.push($(this).text());
					});
					return $("tbody > tr", input).each(function(i) {
						record = {};
						$("td", this).each(function(j) {
							return record[tblCols[j]] = $(this).html();
						});
						return addRecord(record);
					});
				} else {
					throw new Error("unknown input format");
				}
			};

			PivotData.convertToArray = function(input) {
				var result;
				result = [];
				PivotData.forEachRecord(input, {}, function(record) {
					return result.push(record);
				});
				return result;
			};

			PivotData.prototype.arrSort = function(attrs) {
				var a, sortersArr;
				sortersArr = (function() {
					var l, len1, results;
					results = [];
					for (l = 0, len1 = attrs.length; l < len1; l++) {
						a = attrs[l];
						results.push(getSort(this.sorters, a));
					}
					return results;
				}).call(this);
				return function(a, b) {
					var comparison, i, sorter;
					for (i in sortersArr) {
						sorter = sortersArr[i];
						comparison = sorter(a[i], b[i]);
						if (comparison !== 0) {
							return comparison;
						}
					}
					return 0;
				};
			};

			PivotData.prototype.sortKeys = function() {
				if (!this.sorted) {
					this.sorted = true;
					this.rowKeys.sort(this.arrSort(this.rowAttrs));
					return this.colKeys.sort(this.arrSort(this.colAttrs));
				}
				if(!this.allsorted) {
					this.allsorted = true;
					return this.allKeys.sort(this.arrSort(this.allAttrs));
				}
			};

			PivotData.prototype.getColKeys = function() {
				this.sortKeys();
				return this.colKeys;
			};

			PivotData.prototype.getRowKeys = function() {
				this.sortKeys();
				return this.rowKeys;
			};
			
			PivotData.prototype.getAllKeys = function() {
				this.sortKeys();
				return this.allKeys;
			};

			PivotData.prototype.processRecord = function(record) {
				var i, colKey, flatColKey, flatRowKey, l, len1, len2,n, ref, ref1, ref2, ref3,rowKey, x, k;
				colKey = [];
				rowKey = [];
				ref = this.colAttrs;
				for (l = 0, len1 = ref.length; l < len1; l++) {
					x = ref[l];
					colKey.push((ref1 = record[x]) != null ? ref1 : "null");
				}
				ref2 = this.rowAttrs;
				for (n = 0, len2 = ref2.length; n < len2; n++) {
					x = ref2[n];
					rowKey.push((ref3 = record[x]) != null ? ref3 : "null");
				}
				var allKey = rowKey.concat(colKey);
				flatRowKey = rowKey.join(String.fromCharCode(0));
				flatColKey = colKey.join(String.fromCharCode(0));
				
				for (var i = 0; i < this.allTotals.length; i++)
					this.allTotals[i].push(record);
				if (rowKey.length !== 0) {
					if (!this.rowTotals[flatRowKey]) {
						this.rowKeys.push(rowKey);
						if(colKey.length == 0)this.allKeys.push(allKey);
						this.rowTotals[flatRowKey] = [];
						for (i in this.aggregators)
							this.rowTotals[flatRowKey].push(this.aggregators[i](this, rowKey, []));
					}
					for (i = 0; i < this.rowTotals[flatRowKey].length; i++)
						this.rowTotals[flatRowKey][i].push(record);

					var rowKeyCpy = rowKey.concat();
					rowKeyCpy.pop();
					while (rowKeyCpy.length > 0) {
						var flatRowKeyCpy = rowKeyCpy.join(String.fromCharCode(0));
						if (!this.rowTotals[flatRowKeyCpy]) {
							//this.rowKeys.push(rowKey);
							this.rowTotals[flatRowKeyCpy] = [];
							for (i in this.aggregators)
								this.rowTotals[flatRowKeyCpy].push(this.aggregators[i](this, rowKeyCpy, []));
						}
						for (i = 0; i < this.rowTotals[flatRowKeyCpy].length; i++)
							this.rowTotals[flatRowKeyCpy][i].push(record);
						rowKeyCpy.pop();
					}
				}
				if (colKey.length !== 0) {
					if (!this.colTotals[flatColKey]) {
						this.colKeys.push(colKey);
						this.colTotals[flatColKey] = [];
						for (i in this.aggregators)
							this.colTotals[flatColKey].push(this.aggregators[i](this, [], colKey));
					}
					for (i = 0; i < this.colTotals[flatColKey].length; i++)
						this.colTotals[flatColKey][i].push(record);
				}
				
				if(rowKey.length == 0 && colKey.length !== 0)
				{
					var allKeyCpy = allKey.concat();
					var flatAllKeyCpy = allKeyCpy.join(String.fromCharCode(0));
					if(!this.rowTotals[flatAllKeyCpy])this.allKeys.push(allKey);
					while (allKeyCpy.length > 0) {
						if (!this.rowTotals[flatAllKeyCpy]) {
							this.rowTotals[flatAllKeyCpy] = [];
							for (i in this.aggregators)
								this.rowTotals[flatAllKeyCpy].push(this.aggregators[i](this, allKeyCpy, []));
						}
						for (i = 0; i < this.rowTotals[flatAllKeyCpy].length; i++)
							this.rowTotals[flatAllKeyCpy][i].push(record);
						allKeyCpy.pop();
						flatAllKeyCpy = allKeyCpy.join(String.fromCharCode(0));
					}
				}
				else if(rowKey.length != 0 && colKey.length !== 0)
				{
					allKeyCpy = allKey.concat();
					flatAllKeyCpy = allKeyCpy.join(String.fromCharCode(0));
					if(!this.rowTotals[flatAllKeyCpy])this.allKeys.push(allKey);
					while (allKeyCpy.length > 0 && allKeyCpy.length>rowKey.length) {
						if (!this.rowTotals[flatAllKeyCpy]) {
							this.rowTotals[flatAllKeyCpy] = [];
							for (i in this.aggregators)
								this.rowTotals[flatAllKeyCpy].push(this.aggregators[i](this, allKeyCpy, []));
						}
						for (i = 0; i < this.rowTotals[flatAllKeyCpy].length; i++)
							this.rowTotals[flatAllKeyCpy][i].push(record);
						allKeyCpy.pop();
						flatAllKeyCpy = allKeyCpy.join(String.fromCharCode(0));
					}
				}
				
				if (colKey.length !== 0 && rowKey.length !== 0) {
					if (!this.tree[flatRowKey]) {
						this.tree[flatRowKey] = {};
					}
					if (!this.tree[flatRowKey][flatColKey]) {
						this.tree[flatRowKey][flatColKey] = [];
						for (i in this.aggregators)
							this.tree[flatRowKey][flatColKey].push(this.aggregators[i](this, rowKey, colKey));
					}
					var results = [];
					for (i = 0; i < this.tree[flatRowKey][flatColKey].length; i++)
						results.push(this.tree[flatRowKey][flatColKey][i].push(record));
					return results;
				}
			};

			PivotData.prototype.getAggregator = function(rowKey, colKey, aggregatorNum) {
				var agg, flatColKey, flatRowKey;
				flatRowKey = rowKey.join(String.fromCharCode(0));
				flatColKey = colKey.join(String.fromCharCode(0));
				if (rowKey.length === 0 && colKey.length === 0) {
					agg = this.allTotals;
				} else if (rowKey.length === 0) {
					agg = this.colTotals[flatColKey];
				} else if (colKey.length === 0) {
					agg = this.rowTotals[flatRowKey];
				} else {
					agg = this.tree[flatRowKey][flatColKey];
				}
				if (agg != null && agg.length > 0)
					return agg;
				var result = [];
				if (aggregatorNum == 0)
					aggregatorNum = 1;
				for (var i = 0; i < aggregatorNum; i++) {
					result.push({
						value: (function() {
							return null;
						}),
						format: function() {
							return "";
						}
					});
				}
				return result;
			};

			return PivotData;

		})();

		/*
		Default Renderer for hierarchical table layout
		 */
		pivotTableRenderer = function(pivotData, opts) {
			//console.log("pivotData***********" + JSON.stringify(pivotData));
			
			var k, aggregators, aggregator, c, colAttrs, colKey, colKeys, defaults, i, j, r, result, rowAttrs, rowKey, rowKeys, spanSize, td, th, totalAggregators, totalAggregator, tr, txt, val, x;
			var aggregatorNames = [];
			$("#zhi1 li span.pvtAttr").each(
				function() {
					//index.push($(this).data("attrName"));
					var _label_ = $(this).text();
					_label_ = _label_.substring(0, _label_.length - 1);
					aggregatorNames.push(_label_);
				}
			);
			var aggregatorNum = aggregatorNames.length;
			var aggregatorSame = true;
			if (aggregatorNum > 0) {
				var aggregatorTypes = [];var numindex = 0;
				$("#zhi1 li>select").each(function() {
					var selectedIndex = this.selectedIndex;
					var _label_ = this[selectedIndex].label;
					aggregatorTypes.push(_label_);aggregatorNames[numindex]+=("("+_label_+")");numindex++;
				});
				for (k = 0; k < aggregatorNum; k++) {
					if (k == 0)
						continue;
					var pre = aggregatorTypes[k - 1].indexOf("百分比") == -1;
					var now = aggregatorTypes[k].indexOf("百分比") == -1;
					if (pre != now) {
						aggregatorSame = false;
						break;
					}
				}
			}
			defaults = {
				localeStrings: {
					totals: "Totals"
				}
			};
			opts = $.extend(defaults, opts);
			toChinese = pivotData.toChinese;
			colAttrs = pivotData.colAttrs;
			rowAttrs = pivotData.rowAttrs;
			rowKeys = pivotData.getRowKeys();
			colKeys = pivotData.getColKeys();
			result = document.createElement("table");
			result.className = "pvtTable";
			spanSize = function(arr, i, j) {
				var l, len, n, noDraw, ref, ref1, stop, x;
				if (i !== 0) {
					noDraw = true;
					for (x = l = 0, ref = j; 0 <= ref ? l <= ref : l >= ref; x = 0 <= ref ? ++l : --l) {
						if (arr[i - 1][x] !== arr[i][x]) {
							noDraw = false;
						}
					}
					if (noDraw) {
						return -1;
					}
				}
				len = 0;
				while (i + len < arr.length) {
					stop = false;
					for (x = n = 0, ref1 = j; 0 <= ref1 ? n <= ref1 : n >= ref1; x = 0 <= ref1 ? ++n : --n) {
						if (arr[i][x] !== arr[i + len][x]) {
							stop = true;
						}
					}
					if (stop) {
						break;
					}
					len++;
				}
				return len;
			};
			for (j in colAttrs) {
				if (!hasProp.call(colAttrs, j)) continue;
				c = colAttrs[j];
				tr = document.createElement("tr");
				if (parseInt(j) === 0 && rowAttrs.length !== 0) {
					th = document.createElement("th");
					th.setAttribute("colspan", rowAttrs.length);
					th.setAttribute("rowspan", colAttrs.length);
					tr.appendChild(th);
				}
				th = document.createElement("th");
				th.className = "pvtAxisLabel";
//				th.innerHTML = toChinese[c];
                if(toChinese[c].split(".").length>1){
                    var span1=document.createElement("span");
                    span1.className="fulllabel";
                    span1.innerHTML=toChinese[c];
                    var span2=document.createElement("span");
                    span2.className="shortlabel";
                    span2.innerHTML=toChinese[c].split(".")[1];
                    span2.style.display="none";
                    th.appendChild(span1);
                    th.appendChild(span2);
                }
                else{
                    var span1=document.createElement("span");
                    span1.innerHTML=toChinese[c];
                    th.appendChild(span1);
                }
				tr.appendChild(th);
				for (i in colKeys) {
					if (!hasProp.call(colKeys, i)) continue;
					colKey = colKeys[i];
					x = spanSize(colKeys, parseInt(i), parseInt(j));
					if (x !== -1) {
						th = document.createElement("th");
						th.className = "pvtColLabel";
						th.innerHTML = colKey[j];
						/////////////////////////////////////////
						if (aggregatorNum > 1) {
							if (colAttrs.length > 0 && rowAttrs.length > 0) {
								th.setAttribute("colspan", x * aggregatorNum);
							}
							//只有列
							else if (colAttrs.length > 0) {
								th.setAttribute("colspan", x * aggregatorNum);
							}
							//只有行
							else {
								th.setAttribute("colspan", x);
								if (parseInt(j) === colAttrs.length - 1 && rowAttrs.length !== 0) {
									th.setAttribute("rowspan", 2);
								}
							}
						} else {
							th.setAttribute("colspan", x);
							if (parseInt(j) === colAttrs.length - 1 && rowAttrs.length !== 0) {
								th.setAttribute("rowspan", 2);
							}
						}
						tr.appendChild(th);
					}
				}
				if (parseInt(j) === 0) {
					th = document.createElement("th");
					th.className = "pvtTotalLabel";
					th.innerHTML = opts.localeStrings.totals;
					if (aggregatorNum > 1) {
						if (colAttrs.length > 0 && rowAttrs.length > 0) {
							th.setAttribute("colspan", aggregatorNum + 1);
							th.setAttribute("rowspan", colAttrs.length);
						}
						//只有列
						else if (colAttrs.length > 0) {
							th.setAttribute("colspan", aggregatorNum + 1);
							th.setAttribute("rowspan", colAttrs.length);
						}
						//只有列
						else {
							th.setAttribute("rowspan", colAttrs.length + (rowAttrs.length === 0 ? 0 : 1));
						}
					} else {
						th.setAttribute("rowspan", colAttrs.length + (rowAttrs.length === 0 ? 0 : 1));
					}
					tr.appendChild(th);
				}
				result.appendChild(tr);
			}
			//多指标 并且 没有行  （只有列或者没有行没有列）
			if (aggregatorNum > 1) {
				if (rowAttrs.length == 0) {
					tr = document.createElement("tr");
					th = document.createElement("th");
					th.className = "pvtAggregatorTagLabel";
					th.innerHTML = "指标";
					tr.appendChild(th);
					var colkeyslength = colKeys.length;
					for (var n = 0; n < colkeyslength; n++) {
						for (k = 0; k < aggregatorNum; k++) {
							th = document.createElement("th");
							th.className = "pvtColLabel";
							th.innerHTML = aggregatorNames[k];
							tr.appendChild(th);
						}
					}
					for (k = 0; k < aggregatorNum; k++) {
						th = document.createElement("th");
						th.className = "pvtColLabel";
						th.innerHTML = aggregatorNames[k];
						tr.appendChild(th);
					}
					th = document.createElement("th");
					th.className = "pvtColLabel";
					th.innerHTML = "总和";
					tr.appendChild(th);
					result.appendChild(tr);
				}
			}

			if (rowAttrs.length !== 0) {
				tr = document.createElement("tr");
				for (i in rowAttrs) {
					if (!hasProp.call(rowAttrs, i)) continue;
					r = rowAttrs[i];
					th = document.createElement("th");
					th.className = "pvtAxisLabel";
//					th.innerHTML = toChinese[r];
                    if(toChinese[r].split(".").length>1){
                        var span1=document.createElement("span");
                        span1.className="fulllabel";
                        span1.innerHTML=toChinese[r];
                        var span2=document.createElement("span");
                        span2.className="shortlabel";
                        span2.innerHTML=toChinese[r].split(".")[1];
                        span2.style.display="none";
                        th.appendChild(span1);
                        th.appendChild(span2);
                    }
                    else{
                        var span1=document.createElement("span");
                        span1.innerHTML=toChinese[r];
                        th.appendChild(span1);
                    }
					if (colAttrs.length == 0 && aggregatorNum > 1) {
						th.setAttribute("rowspan", 2);
					}
					tr.appendChild(th);
				}
				th = document.createElement("th");
				if (colAttrs.length === 0) {
					//当没有列的时候 最右上角始终是合计
					th.className = "pvtTotalLabel";
					th.innerHTML = opts.localeStrings.totals;
					if (aggregatorNum > 1) {
						th.setAttribute("colspan", aggregatorNum * 2 + 1);
					}
				} else if (aggregatorNum > 1) //当指标大于一个的时候 给出标识
				{
					th.className = "pvtAggregatorTagLabel";
					th.innerHTML = "指标";
				}
				tr.appendChild(th);
				//////////////////////////////////////
				if (aggregatorNum > 1) {
					//行列都有并且指标个数大于0
					if (colAttrs.length > 0) {
						var k = 0;
						while (k < colKeys.length) {
							for (i in aggregatorNames) {
								txt = aggregatorNames[i];
								th = document.createElement("th");
								th.className = "pvtColLabel";
								th.innerHTML = txt;
								tr.appendChild(th);
							}
							k++;
						}
						for (i in aggregatorNames) {
							txt = aggregatorNames[i];
							th = document.createElement("th");
							th.className = "pvtColLabel";
							th.innerHTML = txt;
							tr.appendChild(th);
						}

						th = document.createElement("th");
						th.className = "pvtColLabel";
						th.innerHTML = "总和";
						tr.appendChild(th);
					}
					//只有行
					else {
						result.appendChild(tr);
						tr = document.createElement("tr");
						for (i in aggregatorNames) {
							txt = aggregatorNames[i];
							th = document.createElement("th");
							th.className = "pvtColLabel";
							th.innerHTML = txt;
							tr.appendChild(th);
						}
						th = document.createElement("th");
						th.className = "pvtColLabel";
						th.innerHTML = "总和";
						tr.appendChild(th);
					}
				}
				//////////////////////////////////////
				result.appendChild(tr);
			}
			for (i in rowKeys) {
				if (!hasProp.call(rowKeys, i)) continue;
				rowKey = rowKeys[i];
				tr = document.createElement("tr");
				for (j in rowKey) {
					if (!hasProp.call(rowKey, j)) continue;
					txt = rowKey[j];
					x = spanSize(rowKeys, parseInt(i), parseInt(j));
					if (x !== -1) {
						th = document.createElement("th");
						th.className = "pvtRowLabel";
						th.innerHTML = txt;
						th.setAttribute("rowspan", x);
						if (parseInt(j) === rowAttrs.length - 1 && colAttrs.length !== 0) {
							th.setAttribute("colspan", 2);
						}
						tr.appendChild(th);
					}
				}
				for (j in colKeys) {
					if (!hasProp.call(colKeys, j)) continue;
					colKey = colKeys[j];
					aggregators = pivotData.getAggregator(rowKey, colKey, aggregatorNum);
					//val = aggregator.value();
					////////////////////////////////////////////
					if (aggregatorNum > 1) {
						if (colAttrs.length > 0 && rowAttrs.length > 0) {
							for (k = 0; k < aggregatorNum; k++) {
								aggregator = aggregators[k];
								val = aggregator.value();
								td = document.createElement("td");
								td.className = "pvtVal row" + i + " col" + j;
								td.innerHTML = aggregator.format(val);
								td.setAttribute("data-value", val);
								tr.appendChild(td);
							}
						}
						//只有行 在渲染表格td的时候理论上不会执行到
						else if (rowAttrs.length > 0) {
							alert("0000");
							aggregator = aggregators[0];
							val = aggregator.value();
							td = document.createElement("td");
							td.className = "pvtVal row" + i + " col" + j;
							td.innerHTML = aggregator.format(val);
							td.setAttribute("data-value", val);
							tr.appendChild(td);
						}
						//只有列 在渲染表格td的时候理论上不会被执行到
						else {
							alert("1111");
							aggregator = aggregators[0];
							val = aggregator.value();
							td = document.createElement("td");
							td.className = "pvtVal row" + i + " col" + j;
							td.innerHTML = aggregator.format(val);
							td.setAttribute("data-value", val);
							tr.appendChild(td);
						}
					} else {
						aggregator = aggregators[0];
						val = aggregator.value();
						td = document.createElement("td");
						td.className = "pvtVal row" + i + " col" + j;
						td.innerHTML = aggregator.format(val);
						td.setAttribute("data-value", val);
						tr.appendChild(td);
					}
					//////////////////////////////////////////
				}
				totalAggregators = pivotData.getAggregator(rowKey, [], aggregatorNum);
				//val = totalAggregator.value();
				/*if(aggregatorNum>1 && colAttrs.length==0)
				{
					for(k=0;k<aggregatorNum;k++)
					{
						th = document.createElement("th");
						th.className = "pvtRowAggregatorNameLabel";
						th.innerHTML = aggregatorNames[k];
						tr.appendChild(th);
						
						td = document.createElement("td");
						td.className = "pvtTotal rowTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						td.setAttribute("data-for", "row" + i);
						tr.appendChild(td);
					}
				}*/
				if (aggregatorNum > 1) {
					if (colAttrs.length > 0 && rowAttrs.length > 0) {
						var valTotal = 0;
						for (k = 0; k < aggregatorNum; k++) {
							totalAggregator = totalAggregators[k];
							val = totalAggregator.value();
							if (aggregatorSame)
								valTotal += val;
							td = document.createElement("td");
							td.className = "pvtTotal rowTotal";
							td.innerHTML = totalAggregator.format(val);
							td.setAttribute("data-value", val);
							td.setAttribute("data-for", "row" + i);
							tr.appendChild(td);
						}

						td = document.createElement("td");
						td.className = "pvtTotal rowTotal";
						if (aggregatorSame) {
							td.innerHTML = totalAggregator.format(valTotal);
							td.setAttribute("data-value", valTotal);
						} else {
							td.innerHTML = "无";
						}
						td.setAttribute("data-for", "row" + i);
						tr.appendChild(td);
					}
					//只有行
					else if (rowAttrs.length > 0) {
						valTotal = 0;
						for (k = 0; k < aggregatorNum; k++) {
							totalAggregator = totalAggregators[k];
							val = totalAggregator.value();
							if (aggregatorSame)
								valTotal += val;
							td = document.createElement("td");
							td.className = "pvtTotal rowTotal";
							td.innerHTML = totalAggregator.format(val);
							td.setAttribute("data-value", val);
							td.setAttribute("data-for", "row" + i);
							tr.appendChild(td);
						}

						td = document.createElement("td");
						td.className = "pvtTotal rowTotal";
						if (aggregatorSame) {
							td.innerHTML = totalAggregator.format(valTotal);
							td.setAttribute("data-value", valTotal);
						} else {
							td.innerHTML = "无";
						}
						td.setAttribute("data-for", "row" + i);
						tr.appendChild(td);
					}
					//只有列
					else {
						//理论上不会被执行到
						alert("3333");
						totalAggregator = totalAggregators[0];
						val = totalAggregator.value();
						td = document.createElement("td");
						td.className = "pvtTotal rowTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						td.setAttribute("data-for", "row" + i);
						tr.appendChild(td);
					}
				} else {
					totalAggregator = totalAggregators[0];
					val = totalAggregator.value();
					td = document.createElement("td");
					td.className = "pvtTotal rowTotal";
					td.innerHTML = totalAggregator.format(val);
					td.setAttribute("data-value", val);
					td.setAttribute("data-for", "row" + i);
					tr.appendChild(td);
				}
				result.appendChild(tr);
			}
			tr = document.createElement("tr");
			th = document.createElement("th");
			th.className = "pvtTotalLabel";
			th.innerHTML = opts.localeStrings.totals;
			th.setAttribute("colspan", rowAttrs.length + (colAttrs.length === 0 ? 0 : 1));
			tr.appendChild(th);
			for (j in colKeys) {
				if (!hasProp.call(colKeys, j)) continue;
				colKey = colKeys[j];
				totalAggregators = pivotData.getAggregator([], colKey, aggregatorNum);
				//val = totalAggregator.value();
				if (aggregatorNum > 1) {
					if (rowAttrs.length > 0 && colAttrs.length > 0) {
						for (k = 0; k < aggregatorNum; k++) {
							totalAggregator = totalAggregators[k];
							val = totalAggregator.value();
							td = document.createElement("td");
							td.className = "pvtTotal colTotal";
							td.innerHTML = totalAggregator.format(val);
							td.setAttribute("data-value", val);
							td.setAttribute("data-for", "col" + j);
							tr.appendChild(td);
						}
					}
					//只有行
					else if (rowAttrs.length > 0) {
						//理论上不会被执行到
						alert("4444");
						totalAggregator = totalAggregators[0];
						val = totalAggregator.value();
						td = document.createElement("td");
						td.className = "pvtTotal colTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						td.setAttribute("data-for", "col" + j);
						tr.appendChild(td);
					}
					//只有列
					else if (colAttrs.length > 0) {
						for (k = 0; k < aggregatorNum; k++) {
							totalAggregator = totalAggregators[k];
							val = totalAggregator.value();
							td = document.createElement("td");
							td.className = "pvtTotal colTotal";
							td.innerHTML = totalAggregator.format(val);
							td.setAttribute("data-value", val);
							td.setAttribute("data-for", "col" + j);
							tr.appendChild(td);
						}
					}
					//没有行没有列
					else {
						//理论上不会被执行到
						alert("55555");
						for (k = 0; k < aggregatorNum; k++) {
							totalAggregator = totalAggregators[k];
							val = totalAggregator.value();
							td = document.createElement("td");
							td.className = "pvtTotal colTotal";
							td.innerHTML = totalAggregator.format(val);
							td.setAttribute("data-value", val);
							td.setAttribute("data-for", "col" + j);
							tr.appendChild(td);
						}
					}
				} else {
					totalAggregator = totalAggregators[0];
					val = totalAggregator.value();
					td = document.createElement("td");
					td.className = "pvtTotal colTotal";
					td.innerHTML = totalAggregator.format(val);
					td.setAttribute("data-value", val);
					td.setAttribute("data-for", "col" + j);
					tr.appendChild(td);
				}
			}
			totalAggregators = pivotData.getAggregator([], [], aggregatorNum);
			//val = totalAggregator.value();
			if (aggregatorNum > 1) {
				if (colAttrs.length > 0 && rowAttrs.length > 0) {
					valTotal = 0;
					for (k = 0; k < aggregatorNum; k++) {
						totalAggregator = totalAggregators[k];
						val = totalAggregator.value();
						if (aggregatorSame)
							valTotal += val;
						td = document.createElement("td");
						td.className = "pvtGrandTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						tr.appendChild(td);
					}
					td = document.createElement("td");
					td.className = "pvtGrandTotal";
					if (aggregatorSame) {
						td.innerHTML = totalAggregator.format(valTotal);
						td.setAttribute("data-value", valTotal);
					} else {
						td.innerHTML = "无";
					}
					tr.appendChild(td);

				}
				//只有行
				else if (rowAttrs.length > 0) {
					valTotal = 0;
					for (k = 0; k < aggregatorNum; k++) {
						totalAggregator = totalAggregators[k];
						val = totalAggregator.value();
						if (aggregatorSame)
							valTotal += val;
						td = document.createElement("td");
						td.className = "pvtGrandTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						tr.appendChild(td);
					}

					td = document.createElement("td");
					td.className = "pvtGrandTotal";
					if (aggregatorSame) {
						td.innerHTML = totalAggregator.format(valTotal);
						td.setAttribute("data-value", valTotal);
					} else {
						td.innerHTML = "无";
					}
					tr.appendChild(td);
				}
				//只有列
				else if (colAttrs.length > 0) {
					valTotal = 0;
					for (k = 0; k < aggregatorNum; k++) {
						totalAggregator = totalAggregators[k];
						val = totalAggregator.value();
						if (aggregatorSame)
							valTotal += val;
						td = document.createElement("td");
						td.className = "pvtGrandTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						tr.appendChild(td);
					}
					td = document.createElement("td");
					td.className = "pvtGrandTotal";
					if (aggregatorSame) {
						td.innerHTML = totalAggregator.format(valTotal);
						td.setAttribute("data-value", valTotal);
					} else {
						td.innerHTML = "无";
					}
					tr.appendChild(td);
				}
				//没有行没有列
				else {
					valTotal = 0;
					for (k = 0; k < aggregatorNum; k++) {
						totalAggregator = totalAggregators[k];
						val = totalAggregator.value();
						if (aggregatorSame)
							valTotal += val;
						td = document.createElement("td");
						td.className = "pvtGrandTotal";
						td.innerHTML = totalAggregator.format(val);
						td.setAttribute("data-value", val);
						tr.appendChild(td);
					}
					td = document.createElement("td");
					td.className = "pvtGrandTotal";
					if (aggregatorSame) {
						td.innerHTML = totalAggregator.format(valTotal);
						td.setAttribute("data-value", valTotal);
					} else {
						td.innerHTML = "无";
					}
					tr.appendChild(td);
				}
			} else {
				totalAggregator = totalAggregators[0];
				val = totalAggregator.value();
				td = document.createElement("td");
				td.className = "pvtGrandTotal";
				td.innerHTML = totalAggregator.format(val);
				td.setAttribute("data-value", val);
			}
			tr.appendChild(td);
			result.appendChild(tr);
			result.setAttribute("data-numrows", rowKeys.length);
			result.setAttribute("data-numcols", colKeys.length);
			sessionStorage.setItem("testValue", JSON.stringify(pivotData));
//			清空图标
			$("#treegridput").hide();
			cleanImg();
			return result;

		};

		/*
		Pivot Table core: create PivotData object and call Renderer on it
		 */
		$.fn.pivot = function(input, opts, toChinese) {
			var defaults, e, pivotData2, result, x;
			defaults = {
				cols: [],
				rows: [],
				vals: [],
				filter: function() {
					return true;
				},
				aggregators: [aggregatorTemplates.count()()],
				aggregatorNames: ["计数"],
				sorters: function() {},
				derivedAttributes: {},
				renderer: pivotTableRenderer,
				rendererOptions: null,
				localeStrings: locales.en.localeStrings
			};
			opts = $.extend(defaults, opts);
			result = null;
			try {
				pivotData = new PivotData(input, opts, toChinese);
				try {
					result = opts.renderer(pivotData, opts.rendererOptions);
				} catch (_error) {
					e = _error;
					if (typeof console !== "undefined" && console !== null) {
						console.error(e.stack);
					}
					result = $("<span>").html(opts.localeStrings.renderError);
				}
			} catch (_error) {
				e = _error;
				if (typeof console !== "undefined" && console !== null) {
					console.error(e.stack);
				}
				result = $("<span>").html(opts.localeStrings.computeError);
			}
			x = this[0];
			while (x.hasChildNodes()) {
				x.removeChild(x.lastChild);
			}
			return this.append(result);
		};

		/*
		Pivot Table UI: calls Pivot Table core above with options set by user
		 */

		//html进来第一个方法，传进json的data信息和行列信息
		//初始化信息,打开画面执行一次
		//input是传过来的数据包括column和line 前者是属性，后者是记录
		$.fn.pivotUI = function(input, inputOpts, overwrite, locale) {
			var ainput = input;
			var a, aggregator, attrLength, axisValues, c, colList, defaults, e, existingOpts, fn, i, initialRender, k, l, len1, len2, len3, len4, n, o, opts, pivotTable, q, ref, ref1, ref2, ref3, ref4, refresh, refreshDelayed, renderer, rendererControl, shownAttributes, tblCols, tr1, tr2, uiTable, unusedAttrsVerticalAutoCutoff, unusedAttrsVerticalAutoOverride, x;
			if (overwrite == null) {
				overwrite = false;
			}
			if (locale == null) {
				locale = "en";
			}
			if (locales[locale] == null) {
				locale = "en";
			}
			defaults = {
				derivedAttributes: {},
				aggregators: locales[locale].aggregators,
				renderers: locales[locale].renderers,
				hiddenAttributes: [],
				menuLimit: 200,
				cols: [],
				rows: [],
				vals: [],
				exclusions: {},
				inclusions: {},
				unusedAttrsVertical: 85,
				autoSortUnusedAttrs: false,
				rendererOptions: {
					localeStrings: locales[locale].localeStrings
				},
				onRefresh: null,
				filter: function() {
					return true;
				},
				sorters: function() {},
				localeStrings: locales[locale].localeStrings
			};
			existingOpts = this.data("pivotUIOptions");
			if ((existingOpts == null) || overwrite) {
				//传入Opts和初始化的defaults
				opts = $.extend(defaults, inputOpts);
			} else {
				opts = existingOpts;
			}
			//取数据  tblCols列名数组    axisValues列名对象
			try {
				//      input = PivotData.convertToArray(input);
			
				input = input.lines;
				//      列名中文解释
				var columns = ainput.columns;
				var toChinese = {};
				for (var alen = columns.length, acon = 0; acon < alen; acon++) {
					toChinese[columns[acon].id] = columns[acon].label;
				}
				// tblCols 是所有记录的名称集合
				tblCols = (function() {
					var ref, results;
					ref = input[0];
					results = [];
					for (k in ref) {
						if (!hasProp.call(ref, k)) continue;
						results.push(k);
					}
					return results;
				})();
				// difCols 是一个对象，它里面包含了分类后的记录名称集合
				var difCols = (function() {
					var ref, values;
					ref = ainput.columns;
					values = [];
					results = {};
					for (var aa = 0, bb = ref.length; aa < bb; aa++) {
						
						var tmp = {};
						tmp.label = ref[aa].label;
						tmp.dataField = ref[aa].id;
						tmp.type = ref[aa].concept;
						tmp.othertype = ref[aa].type;//ExtralYear,ExtralMonth
						values.push(tmp);
					}
					
					results.values = values;
					return results;
				})();
				ref = opts.derivedAttributes;
				for (c in ref) {
					if (!hasProp.call(ref, c)) continue;
					if ((indexOf.call(tblCols, c) < 0)) {
						tblCols.push(c);
					}
				}
				axisValues = {};
				for (l = 0, len1 = tblCols.length; l < len1; l++) {
					x = tblCols[l];
					axisValues[x] = {};
				}
				//解析每条数据  
				PivotData.forEachRecord(input, opts.derivedAttributes, function(record) {
					var base, results, v;
					results = [];
					for (k in record) {
						if (!hasProp.call(record, k)) continue;
						v = record[k];
						if (!(opts.filter(record))) {
							continue;
						}
						if (v == null) {
							v = "null";
						}
						if ((base = axisValues[k])[v] == null) {
							base[v] = 0;
						}
						results.push(axisValues[k][v]++);
					}
					return results;
				});
				//        rendererControl = $("<div>");
				//        renderer = $("<select>").addClass('pvtRenderer').appendTo(rendererControl).bind("change", function() {
				//          return refresh();
				//        });
				ref1 = opts.renderers;
				// 生成按钮的代码
				for (x in ref1) {
					if (!hasProp.call(ref1, x)) continue;
					//          $("<option>").val(x).html(x).appendTo(renderer);
					
					if (x == "表格") {
						$("<a>").val(x).attr("id","table").attr("title","表格").addClass("tubiaotable").appendTo($("#tubiao")).bind("click", function() {
							
							$("#table").addClass("on1");
							$("#change").removeClass("on1");
							$("#hot").removeClass("on1");
							$("#colhot").removeClass("on1");
							$("#rowhot").removeClass("on1");
							$("#table").addClass("tubiaotable0");
							$("#change").removeClass("tubiaochange0");
							$("#hot").removeClass("tubiaohot0");
							$("#colhot").removeClass("tubiaocolhot0");
							$("#rowhot").removeClass("tubiaorowhot0");
							$("#tuchart_treegrid").removeClass("on1");
							$("#tuchart_treegrid").removeClass("tubiaotreemap0");
							$("#exporttoexcel").show();
							
							levelSettings.length = 0;
							tuImgList.length = 0;
							levelSubSettings.length = 0;
							$("#tu").val("");
							$("#output").show();
							$("#main").hide();
							$("#main2").hide();
							$(".buton").removeClass("buton");
							$(this).addClass("buton");
							return refresh();
						});
					} else  if(x == "行列转置"){
						$("<a>").val(x).attr("id","change").attr("title","行列转置").addClass("tubiaochange").appendTo($("#tubiao")).bind("click", function() {
							
							$("#change").addClass("on1");
							$("#table").removeClass("on1");
							$("#hot").removeClass("on1");
							$("#colhot").removeClass("on1");
							$("#rowhot").removeClass("on1");
							$("#table").removeClass("tubiaotable0");
							$("#change").addClass("tubiaochange0");
							$("#hot").removeClass("tubiaohot0");
							$("#colhot").removeClass("tubiaocolhot0");
							$("#rowhot").removeClass("tubiaorowhot0");
							$("#tuchart_treegrid").removeClass("on1");
							$("#tuchart_treegrid").removeClass("tubiaotreemap0");
							
							levelSettings.length = 0;
							tuImgList.length = 0;
							levelSubSettings.length = 0;
							$("#tu").val("");
							$("#output").show();
							$("#main").hide();
							$("#main2").hide();
							$(".buton").removeClass("buton");
							$(this).addClass("buton");
							rowcolChanging = true;
							var array = [];
							$("#row li").each(function() {
								array.push($(this).detach());
							});

							$("#col li").each(function() {
								$(this).appendTo($("#row"));
							});

							for (var i in array) {
								$("#col").append(array[i]);
							}
							rowcolChanging = false;
							return refresh();
						});
					}else if(x == "热图"){
						$("<a>").val(x).attr("id","hot").attr("title","热图").addClass("tubiaohot").appendTo($("#tubiao")).bind("click", function() {
							$("#hot").addClass("on1");
							$("#table").removeClass("on1");
							$("#change").removeClass("on1");
							$("#colhot").removeClass("on1");
							$("#rowhot").removeClass("on1");
							$("#table").removeClass("tubiaotable0");
							$("#change").removeClass("tubiaochange0");
							$("#hot").addClass("tubiaohot0");
							$("#colhot").removeClass("tubiaocolhot0");
							$("#rowhot").removeClass("tubiaorowhot0");
							$("#tuchart_treegrid").removeClass("on1");
							$("#tuchart_treegrid").removeClass("tubiaotreemap0");
							$("#exporttoexcel").show();
							
							levelSettings.length = 0;
							tuImgList.length = 0;
							levelSubSettings.length = 0;
							$("#tu").val("");
							$("#output").show();
							$("#main").hide();
							$("#main2").hide();
							$(".buton").removeClass("buton");
							$(this).addClass("buton");
							return refresh();
						});
					}else if(x == "行热图"){
						$("<a>").val(x).attr("id","rowhot").attr("title","行热图").addClass("tubiaorowhot").appendTo($("#tubiao")).bind("click", function() {
							$("#rowhot").addClass("on1");
							$("#table").removeClass("on1");
							$("#change").removeClass("on1");
							$("#colhot").removeClass("on1");
							$("#hot").removeClass("on1");
							$("#table").removeClass("tubiaotable0");
							$("#change").removeClass("tubiaochange0");
							$("#hot").removeClass("tubiaohot0");
							$("#colhot").removeClass("tubiaocolhot0");
							$("#rowhot").addClass("tubiaorowhot0");
							$("#tuchart_treegrid").removeClass("on1");
							$("#tuchart_treegrid").removeClass("tubiaotreemap0");
							$("#exporttoexcel").show();
							
							levelSettings.length = 0;
							tuImgList.length = 0;
							levelSubSettings.length = 0;
							$("#tu").val("");
							$("#output").show();
							$("#main").hide();
							$("#main2").hide();
							$(".buton").removeClass("buton");
							$(this).addClass("buton");
							return refresh();
						});
					}else if(x == "列热图"){
						$("<a>").val(x).attr("id","colhot").attr("title","列热图").addClass("tubiaocolhot").appendTo($("#tubiao")).bind("click", function() {
							$("#colhot").addClass("on1");
							$("#table").removeClass("on1");
							$("#change").removeClass("on1");
							$("#rowhot").removeClass("on1");
							$("#hot").removeClass("on1");
							$("#table").removeClass("tubiaotable0");
							$("#change").removeClass("tubiaochange0");
							$("#hot").removeClass("tubiaohot0");
							$("#colhot").addClass("tubiaocolhot0");
							$("#rowhot").removeClass("tubiaorowhot0");
							$("#tuchart_treegrid").removeClass("on1");
							$("#tuchart_treegrid").removeClass("tubiaotreemap0");
							$("#exporttoexcel").show();
							
							levelSettings.length = 0;
							tuImgList.length = 0;
							levelSubSettings.length = 0;
							$("#tu").val("");
							$("#output").show();
							$("#main").hide();
							$("#main2").hide();
							$(".buton").removeClass("buton");
							$(this).addClass("buton");
							return refresh();
						});
					}else if(x == "树形表格"){
						$("<a>").val(x).attr("id","tuchart_treegrid").attr("title","树形表格").addClass("tubiaotreemap").appendTo($("#tubiao")).bind("click", function() {
							$("#colhot").removeClass("on1");
							$("#table").removeClass("on1");
							$("#change").removeClass("on1");
							$("#rowhot").removeClass("on1");
							$("#hot").removeClass("on1");
							$("#table").removeClass("tubiaotable0");
							$("#change").removeClass("tubiaochange0");
							$("#hot").removeClass("tubiaohot0");
							$("#colhot").removeClass("tubiaocolhot0");
							$("#rowhot").removeClass("tubiaorowhot0");
							$("#tuchart_treegrid").addClass("on1");
							$("#tuchart_treegrid").addClass("tubiaotreemap0");
							$("#exporttoexcel").show();
							treegrid();
							
						});
					}else if(x == "导出到Excel"){
						$("<a>").val(x).attr("id","exporttoexcel").attr("title","导出到Excel").addClass("tubiaoexport").appendTo($("#tubiao")).bind("click", function() {
							exportexcel();
							
						});
					}
					
					
					
					
					
					
					
					
					
					
					
//					if (x == "表格") {
//						$("<button>").val(x).html(x).addClass("buton button").appendTo($("#tubiao")).bind("click", function() {
//							levelSettings.length = 0;
//							tuImgList.length = 0;
//							levelSubSettings.length = 0;
//							$("#tu").val("");
//							$("#output").show();
//							$("#main").hide();
//							$("#main2").hide();
//							$(".buton").removeClass("buton");
//							$(this).addClass("buton");
//							return refresh();
//						});
//					} else {
//						$("<button>").val(x).html(x).addClass("button").appendTo($("#tubiao")).bind("click", function() {
//							levelSettings.length = 0;
//							tuImgList.length = 0;
//							levelSubSettings.length = 0;
//							$("#tu").val("");
//							$("#output").show();
//							$("#main").hide();
//							$("#main2").hide();
//							$(".buton").removeClass("buton");
//							$(this).addClass("buton");
//							if ($(this).val() == "行列转置") {
//								rowcolChanging = true;
//								var array = [];
//								$("#row li").each(function() {
//									array.push($(this).detach());
//								});
//
//								$("#col li").each(function() {
//									$(this).appendTo($("#row div"));
//								});
//
//								for (var i in array) {
//									$("#col div").append(array[i]);
//								}
//								rowcolChanging = false;
//							}
//							return refresh();
//						});
//					}
				}
				//          do1
				//        $("#letop").append(rendererControl);
				shownAttributes = (function() {
					var len2, n, results;
					results = [];
					for (n = 0, len2 = tblCols.length; n < len2; n++) {
						c = tblCols[n];
						if (indexOf.call(opts.hiddenAttributes, c) < 0) {
							results.push(c);
						}
					}
					return results;
				})();
				//          分指标，维度      添加div块
				//   参数c是显示的名称，为该记录的label；uiAb是；cName是英文名称，即该记录的name；str是数据的分类，值为dim或value；itemType是该记录的类型，目前分为dim，date以及value,subtype是用来区分日期的年月拆分，年：ExtralYear,月：ExtralMonth
				ffn = function(c, uiAb, cName, str, itemType, subtype, number) {
					var attrElem, btns, checkContainer, filterItem, filterItemExcluded, hasExcludedItem, keys, len3, o, ref2, showFilterList, triangleLink, updateFilter, splitDate, v, valueList;
//					给key赋值
					keys = (function() {
						var results;
						results = [];
						for (k in axisValues[cName]) {
							results.push(k);
						}
						return results;
					})();
					
					hasExcludedItem = false;
					valueList = $("<div>").addClass('pvtFilterBox').hide(); //valueList属性选择box的画面
                    var h4=$("<h4>");
                    var ch4=$("<span>").text(" ("+ keys.length + ")");
                    if(c.split(".").length>1){
                        var cfulltext=$("<span>").addClass("fulltext").text(c);
                        var cshorttext=$("<span>").addClass("shorttext").text(c.split('.')[1]).hide();
                        h4.append(cfulltext,cshorttext,ch4);
                    }
                    else{
                        var cfulltext=$("<span>").text(c);
                        h4.append(cfulltext,ch4);
                    }
                    valueList.append(h4);
//					valueList.append($("<h4>").text(c + " (" + keys.length + ")"));
					valueList.append($("<div class='pvtBox' onclick='closeBox(this)'>"));
					if (keys.length > opts.menuLimit) {
						valueList.append($("<p>").html(opts.localeStrings.tooMany));					
					} else {
						btns = $("<p>").appendTo(valueList);
//						添加一个鼠标单击时的下拉菜单
						btns.append($("<button>", {
							type: "button"
						}).html(opts.localeStrings.selectAll).bind("click", function() {//下面的代码表示筛选过的记录会打勾
							if (itemType != "date")
								return valueList.find("input:visible").prop("checked", true);
							else
								return zTreeSelectAll("dateTree" + cName, true);
						}));
						btns.append($("<button>", {
							type: "button"
						}).html(opts.localeStrings.selectNone).bind("click", function() {//同上
							if (itemType != "date")
								return valueList.find("input:visible").prop("checked", false);
							else
								return zTreeSelectAll("dateTree" + cName, false);
						}));
						btns.append($("<br>"));
						btns.append($("<input>", {
							type: "text",
							placeholder: opts.localeStrings.filterResults,//输入框为空时的提示语句
							"class": "pvtSearch"
						}).bind("keyup", function() {
							var filter;
							filter = $(this).val().toLowerCase();
							if (itemType != "date") {
								return valueList.find('.pvtCheckContainer p').each(function() {
									var testString;
									testString = $(this).text().toLowerCase().indexOf(filter);
									if (testString !== -1) {
										return $(this).show();//显示符合条件的记录
									} else {
										return $(this).hide();//隐藏不符合条件的记录
									}
								});
							} else {
								resetZtree(filter, filterItem, treeDataBase, "dateTree" + cName);
							}
						}));
//						alert("aaa");
						checkContainer = $("<div>").addClass("pvtCheckContainer").appendTo(valueList); //可选变量
						ref2 = keys.sort(getSort(opts.sorters, cName));
						if (itemType != "date") {
							for (o = 0, len3 = ref2.length; o < len3; o++) {
								k = ref2[o];
								v = axisValues[cName][k];
								filterItem = $("<label>");
								filterItemExcluded = false;
								if (opts.inclusions[cName]) {
									filterItemExcluded = (indexOf.call(opts.inclusions[cName], k) < 0);
								} else if (opts.exclusions[cName]) {
									filterItemExcluded = (indexOf.call(opts.exclusions[cName], k) >= 0);
								}
								hasExcludedItem || (hasExcludedItem = filterItemExcluded);
								$("<input>").attr("type", "checkbox").addClass('pvtFilter').attr("checked", !filterItemExcluded).data("filter", [cName, k]).appendTo(filterItem);
								filterItem.append($("<span>").html(k));
								filterItem.append($("<span>").text(" (" + v + ")"));
								checkContainer.append($("<p>").append(filterItem)); //filterItem可选check项
							}
						} else {
							var treeDataBase = [];
							for (o = 0, len3 = ref2.length; o < len3; o++) {
								k = ref2[o];
								v = axisValues[cName][k];
								filterItemExcluded = false;
								if (opts.inclusions[cName]) {
									filterItemExcluded = (indexOf.call(opts.inclusions[cName], k) < 0);
								} else if (opts.exclusions[cName]) {
									filterItemExcluded = (indexOf.call(opts.exclusions[cName], k) >= 0);
								}
								hasExcludedItem || (hasExcludedItem = filterItemExcluded);
								treeDataBase.push({
									value: k,
									checked: !filterItemExcluded,
									filter: [cName, k]
								});
							}
							var treeData = changeDataToZtree(treeDataBase);
							filterItem = $("<ul>").attr("id", "dateTree" + cName);
							checkContainer.append(filterItem.addClass('ztree'));
							initZtree(filterItem, treeData);
						}
						
						
					}
					
					
					
					updateFilter = function() {
						if(itemType != "date")
						{
							var unselectedCount;
							unselectedCount = valueList.find("[type='checkbox']").length - valueList.find("[type='checkbox']:checked").length;
							if (unselectedCount > 0) {
								attrElem.addClass("pvtFilteredAttribute");
							} else {
								attrElem.removeClass("pvtFilteredAttribute");
							}
							if (keys.length > opts.menuLimit) {
								return valueList.toggle();
							} else {
								return valueList.toggle(0, refresh);
							}
						}else{
							var NumOffalse = getFilterCheckNode("dateTree" + cName,false);
							if(NumOffalse > 0){
								attrElem.addClass("pvtFilteredAttribute");
							} else {
								attrElem.removeClass("pvtFilteredAttribute");
							}
							if (keys.length > opts.menuLimit) {
								return valueList.toggle();
							} else {
								return valueList.toggle(0, refresh);
							}
						}
						
					};
					splitDate = function() {
						$("#wei li."+cName+"-year").show();$("#wei li."+cName+"-month").show();return valueList.toggle();
					}
					var lineh = $("<p>");
					if (itemType == "date") {
							lineh.append($("<button>", {type: "button"}).text("拆分")).bind("click", splitDate);
					}
					lineh.appendTo(valueList).append($("<button>", {
						type: "button"
					}).text("确认").bind("click", updateFilter));

					bindBodyDown = function(current) {
						$("body").bind("mousedown", current, onBodyDown);
					}
					unbindBodyDown = function(current) {
						$("body").unbind("mousedown", onBodyDown);
					}

					onBodyDown = function(e) {
						if (e.target != null) {
							var _class_ = $(e.target).attr('class');
							if (_class_ != undefined) {
								if (_class_ == "pvtTriangle" || _class_.indexOf("pvtAttr") != -1)
									return;
							}
						}
						var current = e.data;
						if (current != null && current != undefined) {
							if (e.target == null) return;
							if ($(e.target).isChildAndSelfOf(current))
								return;
							if (!current.is(":hidden"))
								current.fadeOut("fast", unbindBodyDown);
						}
					}

					showFilterList = function(e) {
						if (valueList.is(":hidden")) {
							valueList.slideDown("fast", function() {
								bindBodyDown(valueList)
							});
						} else {
							valueList.fadeOut("fast", function() {
								bindBodyDown(valueList)
							});
						}
						var clickLeft, clickTop, ref3, windowHeight, currentHeight, elementHeight;
						if (e != null) {
							
							clickLeft = e.clientX;clickTop = e.clientY;windowHeight = $(window).outerHeight();
							elementHeight = valueList.find("button:last").position().top + 30;
							var valueListLeft = clickLeft; var valueListTop = clickTop;
							if((valueListTop+elementHeight)>windowHeight)
								valueListTop-=(elementHeight+22);
							if(valueListTop < 0)
							{
								valueListTop = 5;;
							}
							valueList.css({left:valueListLeft+10,top:valueListTop});
							/*
							ref3 = $(e.currentTarget).position(), clickLeft = ref3.left, clickTop = ref3.top;
							windowHeight = $(window).outerHeight();
							currentHeight = e.currentTarget.offsetTop;
							elementHeight = valueList.find("button:last").position().top + 30;
							if ((windowHeight - currentHeight > elementHeight) && (currentHeight < elementHeight)) {
								valueList.css({
										left: clickLeft + 20,
										top: clickTop + 10
									});									
							}
							else{
								valueList.css({
											left:  180,
											top: 230
										});
							}*/
						}
						
						//toggle('fast');
						valueList.find('.pvtSearch').val('');
						return valueList.find('.pvtCheckContainer p').show();
					};
					triangleLink = $("<span>").addClass('pvtTriangle').html("&#x25BE;").bind("click", showFilterList);
					var i = $.inArray(cName, shownAttributes);
                    attrElem = $("<li>").addClass("axis_" + i + " " + str).css("width","97%");
                    var clname=$("<span>").addClass('pvtAttr').attr("attrName", cName);
                    if(c.split(".").length>1){
                        var cfullname=$("<span>").addClass("fullname").text(c);
                        var cshortname=$("<span>").addClass("shortname").text(c.split(".")[1]).hide();
                        clname.append(cfullname,cshortname);
                    }
                    else{
                        var cfullname=$("<span>").text(c);
                        clname.append(cfullname);
                    }
                    clname.append(triangleLink);
                    attrElem.append(clname);
//					attrElem = $("<li>").addClass("axis_" + i + " " + str).append($("<span>").addClass('pvtAttr').text(c).data("attrName", cName).append(triangleLink));
                    if (hasExcludedItem) {
						attrElem.addClass('pvtFilteredAttribute');
					}
					if(subtype == "ExtralYear" || subtype == "ExtralMonth")
					{
						attrElem.addClass(cName).css("font-family","bold");attrElem.hide();
					}
					//图标下拉的框
					var pullSetImg = "<div class='"+'axis_'+i+'Tu'+' '+'imgSet'+"' style='display:none; border:1px solid;'><form name='"+number+'tu'+"'>"+
      								"<label class='option'><input type='radio' name='tu' onclick='pullSure(this)' value='independent'><img src='pic/smallIcon/independent.png' />独立子图</input></label>"+
									"<label class='option'><input type='radio' name='tu' onclick='pullSure(this)' value='embed'><img src='pic/smallIcon/embed.png' />嵌入上层</input></label> "+
									"<label class='option'><input type='radio' name='tu' onclick='pullSure(this)' value='stop'><img src='pic/smallIcon/stop.png' />停止</input></label>"+
										"</form></div>";
					var pullTiSt = 	"<div class='"+'axis_'+i+'Pu'+' '+'imgSet'+"' style='display:none; border:1px solid;'><form name='"+number+'pu'+"'>"+
									"<label class='option'><input type='radio' name='pu' onclick='pullSure(this)' value='tile'><img src='pic/smallIcon/tile.png' />平铺</input></label>"+
									"<label class='option'><input type='radio' name='pu' onclick='pullSure(this)' value='stack'><img src='pic/smallIcon/stack.png' />堆积</input></label>"+
									"</form></div>";
					var pullImg = 	"<div class='"+'axis_'+i+'Img'+' '+'imgSet'+"' style='display:none; border:1px solid;'><form name='"+number+'img'+"'>"+
									"<label class='option'><input type='radio' name='img' onclick='imgPull(this)' value='histogram'><img src='pic/smallIcon/histogram.png' />柱状图</input></label>"+
									"<label class='option'><input type='radio' name='img' onclick='imgPull(this)' value='area'><img src='pic/smallIcon/area.png' />面积图</input></label>"+
									"<label class='option'><input type='radio' name='img' onclick='imgPull(this)' value='pie'><img src='pic/smallIcon/pie.png' />饼图</input></label>"+
									"<label class='option'><input type='radio' name='img' onclick='imgPull(this)' value='radar'><img src='pic/smallIcon/radar.png' />雷达图</input></label>"+
									"<label class='option'><input type='radio' name='img' onclick='imgPull(this)' value='line'><img src='pic/smallIcon/line.png' />折线图</input></label>"+
									"</form></div>";
					//attrElem为选择参数
					uiAb.append(attrElem);
					uiAb.append(valueList).after(pullImg).after(pullTiSt).after(pullSetImg);
					var wordSpan = $(attrElem).find("span.pvtAttr")
					return wordSpan.bind("dblclick", showFilterList); //双击显示FilterList box画面
				};
				
				var uiDim = $("#wei");
//				添加指标
				var uiValue = $("#zhi");
				
				
				for(var aa = 0, bb = difCols.values.length; aa < bb; aa++)
				{
					var item = difCols.values[aa];
					var _lower_type_ = item.type.toLowerCase();
					var _subtype = item.othertype;
					ffn(item.label , item.type=="Value"?uiValue:uiDim , item.dataField,item.type=="Value"?"dim":"value", _lower_type_ , _subtype, aa);
				}
//在三角形下拉框后添加图标，隐藏
				var imgChart = "<img class='newImg histogram tuImg' src='pic/smallIcon/histogram.png' value='histogram' onclick='pullImg(this)' />"+
										"<img class='newImg area tuImg' src='pic/smallIcon/area.png' value='area' onclick='pullImg(this)' />"+
										"<img class='newImg pie tuImg' src='pic/smallIcon/pie.png' value='pie' onclick='pullImg(this)' />"+
										"<img class='newImg radar tuImg' src='pic/smallIcon/radar.png' value='radar' onclick='pullImg(this)' />"+
										"<img class='newImg line tuImg' src='pic/smallIcon/line.png' value='line' onclick='pullImg(this)' />"+
										"<img class='newImg treegrid tuImg' src='pic/smallIcon/table.png' value='treegrid' onclick='pullImg(this)' />";
				var imgSet = "<img class='newImg independent imgSetA' onclick='pullSet(this)' value='independent' src='pic/smallIcon/independent.png' />"+
							 "<img class='newImg embed imgSetA' onclick='pullSet(this)' value='embed' src='pic/smallIcon/embed.png' />"+
							 "<img class='newImg stop imgSetA' onclick='pullSet(this)' value='stop' src='pic/smallIcon/stop.png' />";
				//tile 平铺  stack 堆积
			    var tiSt = "<img class='newImg stackImg stack' onclick='pullTiSt(this)' value='stack' src='pic/smallIcon/stack.png' />"+
			    		   "<img class='newImg stackImg tile' onclick='pullTiSt(this)' value='tile' src='pic/smallIcon/tile.png' />";
//				$(".pvtTriangle").after(tiSt).after(imgSet).after(imgChart);
				
				var sp = $("<span>").addClass("imgSetSpan");
				$(".pvtAttr").before(sp);
				
				$(".imgSetSpan").append(imgChart).append(imgSet).append(tiSt);
				$(".newImg").hide();					
				//          算法选择
				aggregator = $("<select>").addClass('pvtAggregator').bind("change", function() {
					return refresh();
				});
				ref2 = opts.aggregators;
				for (x in ref2) {
					if (!hasProp.call(ref2, x)) continue;
					aggregator.append($("<option>").val(x).html(x));
				}
				//        $("<div>").addClass('pvtVals').css("width","188px").appendTo($("#zhi1")).append(aggregator).append($("<br>"));//计数等选择
				//          do1
				//          $("#zhi1").append(aggregator).append($("<br>"));
				aggregator.addClass("do").hide().appendTo($("#zhi1"));
				//          pivotTable=$("<div>").attr("valign", "top").addClass('pvtRendererArea');
				pivotTable = $("<div>").addClass('pvtRendererArea');
				this.html(pivotTable); //uiTable基本表格
				ref3 = opts.cols;
				for (o = 0, len3 = ref3.length; o < len3; o++) {
					x = ref3[o];
					this.find(".pvtCols").append(this.find(".axis_" + ($.inArray(x, shownAttributes)) + " dim"));
				}
				ref4 = opts.rows;
				for (q = 0, len4 = ref4.length; q < len4; q++) {
					x = ref4[q];
					this.find(".pvtRows").append(this.find(".axis_" + ($.inArray(x, shownAttributes))) + " dim");
				}
				if (opts.aggregatorName != null) {
					this.find(".pvtAggregator").val(opts.aggregatorName);
				}
				if (opts.rendererName != null) {
					this.find(".pvtRenderer").val(opts.rendererName);
				}
				initialRender = true;
				refreshDelayed = (function(_this, weiui, zhiui) {
					return function(_mode__,_level__) {
						var attr, exclusions, inclusions, len5, newDropdown, numInputsToProcess, pivotUIOptions, pvtVals, ref5, ref6, s, subopts, t, unusedAttrsContainer, vals;
						subopts = {
							derivedAttributes: opts.derivedAttributes,
							localeStrings: opts.localeStrings,
							rendererOptions: opts.rendererOptions,
							sorters: opts.sorters,
							cols: [],
							rows: []
						};
						//numInputsToProcess = (ref5 = opts.aggregators[aggregator.val()]([])().numInputs) != null ? ref5 : 0;
						vals = [];
						$("#row li span.pvtAttr").each(function() {
							return subopts.rows.push($(this).attr("attrName"));
						});
						$("#col li span.pvtAttr").each(function() {
							return subopts.cols.push($(this).attr("attrName"));
						});
						$("#zhi1 li span.pvtAttr").each(function() {
							return vals.push($(this).attr("attrName"));
						});
						
						//              算法选择
						var aggregatorValues = [];
						$("#zhi1 li>select").each(function() {
							var selectedIndex = this.selectedIndex;
							var _label_ = this[selectedIndex].label;
							aggregatorValues.push(_label_);
						});
						if (aggregatorValues.length == 0)
							aggregatorValues.push("计数");
						subopts.aggregatorNames = aggregatorValues;
						subopts.vals = vals;
						subopts.aggregators = [];
						for (var kkk in aggregatorValues) {
							var _label_ = aggregatorValues[kkk];
							var _var_ = vals[kkk];
							if (_label_.indexOf("百分比") == -1)
								subopts.aggregators.push(opts.aggregators[_label_]([_var_]));
							else
								subopts.aggregators.push(opts.aggregators[_label_]([_var_], kkk));
						}
						//              表格之类的选中
						var rendererValue = $(".buton").val();
						subopts.renderer = opts.renderers[rendererValue];
						exclusions = {};
						var excfunc = function() {
							var filter;
							filter = $(this).data("filter");
							if (exclusions[filter[0]] != null) {
								return exclusions[filter[0]].push(filter[1]);
							} else {
								return exclusions[filter[0]] = [filter[1]];
							}
						};

						var ztreefilterexcFunc = function() {
							var _id_ = $(this).attr("id");
							var filterNodes = getFilterCheckNode(_id_, false);
							for (var __i_ in filterNodes) {
								var item = filterNodes[__i_];
								var filter = item.filter;
								if (exclusions[filter[0]] != null) {
									exclusions[filter[0]].push(filter[1]);
								} else {
									exclusions[filter[0]] = [filter[1]];
								}
							}
						}
						zhiui.find('input.pvtFilter').not(':checked').each(excfunc);
						weiui.find('input.pvtFilter').not(':checked').each(excfunc);
						weiui.find('ul.ztree').each(ztreefilterexcFunc);
						inclusions = {};
						var incfunc = function() {
							var filter;
							filter = $(this).data("filter");
							if (exclusions[filter[0]] != null) {
								if (inclusions[filter[0]] != null) {
									return inclusions[filter[0]].push(filter[1]);
								} else {
									return inclusions[filter[0]] = [filter[1]];
								}
							}
						};
						var ztreefilterincFunc = function() {
							var _id_ = $(this).attr("id");
							var filterNodes = getFilterCheckNode(_id_, true);
							for (var __i_ in filterNodes) {
								var item = filterNodes[__i_];
								var filter = item.filter;
								if (exclusions[filter[0]] != null) {
									if (inclusions[filter[0]] != null) {
										inclusions[filter[0]].push(filter[1]);
									} else {
										inclusions[filter[0]] = [filter[1]];
									}
								}
							}
						}
						zhiui.find('input.pvtFilter:checked').each(incfunc);
						weiui.find('input.pvtFilter:checked').each(incfunc);
						weiui.find('ul.ztree').each(ztreefilterincFunc);
						subopts.filter = function(record) {
							var excludedItems, ref7;
							if (!opts.filter(record)) {
								return false;
							}
							for (k in exclusions) {
								excludedItems = exclusions[k];
								if (ref7 = "" + record[k], indexOf.call(excludedItems, ref7) >= 0) {
									return false;
								}
							}
							return true;
						};
						pivotTable.pivot(input, subopts, toChinese);
//11              设置table大小
						pivotTable.children(".pvtTable").css("width", "100%");
						// 定义了一个变量 返回名为opts的object变量
						pivotUIOptions = $.extend(opts, {
							cols: subopts.cols,
							rows: subopts.rows,
							vals: vals,
							exclusions: exclusions,
							inclusions: inclusions,
							inclusionsInfo: inclusions,
							aggregatorNames: aggregatorValues,
							rendererName: rendererValue
						});
						_this.data("pivotUIOptions", pivotUIOptions);
						if (opts.autoSortUnusedAttrs) {
							unusedAttrsContainer = _this.find("td.pvtUnused.pvtAxisContainer");
							$(unusedAttrsContainer).children("li").sort(function(a, b) {
								return naturalSort($(a).text(), $(b).text());
							}).appendTo(unusedAttrsContainer);
						}
						pivotTable.css("opacity", 1);
						if (opts.onRefresh != null) {
							return opts.onRefresh(pivotUIOptions);
						}
						//tuSort();//图标显示排序
						//              图表方法刷新
						if ($("#tu").val() != "") {
							window[$("#tu").val()](0,[],typeof(_mode__) == "undefined"?"button":_mode__,_level__);
						}
					};
				})(this, uiDim, uiValue);
				refreshExternal = refresh = (function(_this) {
					return function(_mode__,_level__) {
						pivotTable.css("opacity", 0.5);
						if(typeof(_mode__)=="undefined")
						{
							return setTimeout(refreshDelayed, 10);
						}
						else
						{
							setTimeout(refreshDelayed(_mode__,_level__),10);
						}
						
					};
				})(this);
				refresh();
				//        this.find(".pvtAxisContainer").sortable({
				//          update: function(e, ui) {
				//            if (ui.sender == null) {
				//              return refresh();
				//            }
				//          },
				//          connectWith: this.find(".pvtAxisContainer"),
				//          items: 'li',
				//          placeholder: 'pvtPlaceholder'
				//        });
//				第一行，第一列
				/*$(".yi").sortable({
					update: function(e, ui) {
						if (ui.sender == null && !rowcolChanging) {
							return refresh();
						}
					},
					connectWith: ".yi",
					items: 'li',
					placeholder: 'pvtPlaceholder'
				});*/
				//				第二指标框
				$("#zhi1").sortable({
					update: function(e, ui) {
						if (ui.sender == null && !rowcolChanging) {
							return refresh();
						}
					},
					items: 'li',
					placeholder: 'pvtPlaceholder',
					receive: function(event, ui) {	          	
						//ui.item.css({"width":"97%","margin-left":"3px"});
					},
					start:function(event,ui)
					{
						ui.item.css("width","");
					}
				});/*.droppable({
					 drop: function( event, ui ) {
						ui.draggable.clone(true).css("width","97%").append($("#zhi1>select").clone(true).show().val("合计").css({position:"relative",right:"-2px",top:"2px"})).appendTo(this);
						var _pvtTirangle = ui.draggable.find('.pvtTriangle');
						
						$._data(ui.draggable.find('.pvtTriangle')[0],'events')
					 }
				});*/
				$("#zhi>li").draggable({
					  connectToSortable: "#zhi1",
					  helper:'clone'/*function(event)
					  {
						return $(event.delegateTarget).clone(true);
					  }*/,
					  start:function(event,ui)
					  {
						$(ui.helper[0]).css("width","");
					  },
					  stop:function(event,ui)
					  {
						var _context = $(ui.helper['context']);
						var clickfunc = $._data(_context.find(".pvtTriangle")[0],'events')['click'][0].handler;
						var _data = _context.find("span.pvtAttr").data("attrName");
						$(ui.helper[0]).css("width","97%").removeClass("ui-draggable").removeClass("ui-draggable-handle").find(".pvtTriangle").bind('click',clickfunc).find("span.pvtAttr").data("attrName",_data);
						$("#zhi1>select").clone(true).show().val("合计").css({position:"relative",right:"-2px",top:"2px"}).appendTo($(ui.helper[0]));
//					  	var thebtn = "<img style='width:12px;height:12px' src='../css/img/drop.png' onclick='(function(this){$(this).parent().remove();})()' />";
						//var thebtn = "<img style='width:12px;height:12px' src='./css/img/drop.png' onclick='dropnode(this)' />";
						var thebtn = "<i class='fa fa-close' style='position:absolute;top:1px;right:-1px;font-size:12px;cursor:pointer' onclick='dropnode(this)'></i>";
					  	$(ui.helper[0]).append(thebtn);
					  }
				});
				
				$(".su").sortable({
					update: function(e, ui) {
						if (ui.sender == null && !rowcolChanging) {
							return refresh();
						}
					},
					connectWith: ".su",
					items: 'li',
					placeholder: 'ui-state-highlight'
					//'pvtPlaceholder'
				});
				
				
				//列
				//$("#zhi").sortable({
					/*stop:function(event,ui)
					{
						var _id = ui.item.parent().attr("id");
						if(_id != "zhi1")
							return false;
					},*/
					/*start:function(event,ui)
					{
						ui.item.css("width","");
					}
				});*/
				$("#col").sortable({
					receive: function(event, ui) {
						//ui.item.css("float", "none");
						ui.item.css("width","97%").css("margin-left","3px");
					},
					remove: function(event, ui) {	
						//		拖出隐藏
						var liClass = ui.item[0].classList[0];
						$("."+liClass+" img").hide();
						ui.item.css("width","");
						//-jon ui.item.css("float", "left");
						//拖出显示省略文字（有细节错误）
						omitfield(event.toElement);
					},
					start:function(event,ui)
					{
						ui.item.css("width","");
					}
					/*,
					stop:function(event,ui){
						var _id = ui.item.parent().attr("id");
						if(_id == "zhi")
						{
							ui.item.css({"width":"97%","margin-left":"0px"});
							return false;
						}
					}*/
				});
				//行
				$("#row").sortable({
					receive: function(event, ui) {	          	
						ui.item.css("width","97%").css("margin-left","3px");
					},
					remove: function(event, ui) {	
//						//		拖出隐藏
								var liClass = ui.item[0].classList[0];
								$("."+liClass+" img").hide();
								//ui.item.removeAttr("style");
								ui.item.css("width","");
								// -jon ui.item.css("float", "left");
//						//拖出显示省略文字（有细节错误）
						omitfield(event.toElement);
					},
					start:function(event,ui)
					{
						ui.item.css("width","");
					}
					/*,
					stop:function(event,ui){
						var _id = ui.item.parent().attr("id");
						if(_id == "zhi")
						{
							ui.item.css({"width":"97%","margin-left":"0px"});
							return false;
						}
					}*/
				});
			
			  $("#wei").sortable({
					/*stop:function(event,ui){
						var _id = ui.item.parent().attr("id");
						if(_id == "zhi")
						{
							ui.item.css({"width":"97%","margin-left":"0px"});
							return false;
						}
					}*/
					receive: function(event, ui) {	          	
						ui.item.css("width","97%").css("margin-left","3px");
					},
					start:function(event,ui)
					{
						ui.item.css("width","");
					}
			  });
			} catch (_error) {
				e = _error;
				if (typeof console !== "undefined" && console !== null) {
					console.error(e.stack);
				}
				this.html(opts.localeStrings.uiRenderError);
			}
			return this;
		};

	function tuSort(){
				var current = $("#tu").val();
				//选择默认数组放入
				var tuArray = new Array();
				var puArray = new Array();
				var Sort = sortChart();//排序好的数组
			//显示第一个图标,并且选中默认值
				if (current == "histogram") {
					for (var i=0; i<Sort.length; i++) {
						$(".axis_"+Sort[i].className[5]+"Img input[value='histogram']").click(); //默认选中柱状图
						$(Sort[i]).find(".tuImg:visible").hide();
						$(Sort[i]).find(".histogram").show();
					}							
				}
				if (current == "area") {
					for (var i=0; i<Sort.length; i++) {
						$(".axis_"+Sort[i].className[5]+"Img input[value='area']").click();
						$(Sort[i]).find(".tuImg:visible").hide();
						$(Sort[i]).find(".area").show();
					}
				}
				if (current == "pie") {
					for (var i=0; i<Sort.length; i++) {
						$(".axis_"+Sort[i].className[5]+"Img input[value='pie']").click();
						$(Sort[i]).find(".tuImg:visible").hide();
						$(Sort[i]).find(".pie").show();
					}
				}
				if (current == "radar") {
					for (var i=0; i<Sort.length; i++) {
						$(".axis_"+Sort[i].className[5]+"Img input[value='radar']").click();
						$(Sort[i]).find(".tuImg:visible").hide();
						$(Sort[i]).find(".radar").show();
					}
				}
				if (current == "treegrid") {
					for (var i=0; i<Sort.length; i++) {
						$(".axis_"+Sort[i].className[5]+"Img input[value='treegrid']").click();
						$(Sort[i]).find(".tuImg:visible").hide();
						$(Sort[i]).find(".treegrid").show();
					}
				}	
				levelSettings.length = 0; //清空第二个设置数组
		//面积，雷达，树状表格，柱状图
			if ($("#tu").val() == "area"||$("#tu").val() == "radar"||$("#tu").val() == "treegrid"||$("#tu").val() == "histogram") {
					
						
					//奇数
					for (var b=0; b<Sort.length; b+=2) {	
										
						var liClass = Sort[b].classList[0];						
						$("."+ liClass +" .imgSetA").hide();
						$("."+liClass+"Tu input")[0].checked = true;
						tuArray[b] = "independent";
						if ($("#tu").val() == "histogram" || $("#tu").val() == "area") {
							$("."+liClass+"Pu input")[0].checked = true;
							$("."+liClass+" .stackImg").hide();
							$("."+liClass+" .tile").show();
							puArray[b] = "tile";
						} 							
			         		$("."+liClass+" .independent").show();
			         	
					}
					//偶数
					for (var c=1; c<Sort.length; c+=2) {
						var liClass = Sort[c].classList[0];
						$("."+ liClass +" .imgSetA").hide();
						$("."+liClass+"Tu input")[1].checked = true;
						tuArray[c] = "embed";						
						if ($("#tu").val() == "histogram" || $("#tu").val() == "area") {
							$("."+liClass+"Pu input")[1].checked = true;
							$("."+ liClass +" .stackImg").hide();
							$("."+liClass+" .stack").show();
							puArray[c] = "stack";
						} 							
			         		$("."+liClass+" img.embed").show();
			         	
					}
				}
//			饼图
				if ($("#tu").val() == "pie") {	
					
					for (var c=0; c<Sort.length; c++) {
						var liClass = Sort[c].classList[0];
						if (c==0) {
							$("."+liClass+" .imgSetA:visible").hide();
		         			$("."+liClass+" .independent").show();
		         			$("."+liClass+"Tu input")[0].checked = true;
		         			tuArray[c] = "independent";
			         	} else {
							$("."+liClass+" .imgSetA:visible").hide();
							$("."+liClass+" .embed").show();							
							$("."+liClass+"Tu input")[1].checked = true;
							tuArray[c] = "embed";
			         	}						
					}
				}
					levelSettings = tuArray;
				//更改是否可以下拉
				for (var i=0; i<tuArray.length; i++) {
					var className = Sort[i].classList[0];
					if (tuArray[i] == "embed") {//当设置为嵌入的时候第一个图标不能下拉,第二个可以
						$('.'+className+" .tuImg:visible").removeAttr("onclick");
						$('.'+className+" .tuImg:visible").css("cursor","auto");						
						$('.'+className+" .imgSetA:visible").attr("onclick","pullSet(this)");
						$('.'+className+" .imgSetA:visible").css("cursor","pointer");
					} else{//独立或者是停止时，第一个图可下拉，第二个也可以
						$('.'+className+" .tuImg:visible").attr("onclick","pullImg(this)");
						$('.'+className+" .tuImg:visible").css("cursor","pointer");
						$('.'+className+" .imgSetA:visible").attr("onclick","pullSet(this)");
						$('.'+className+" .imgSetA:visible").css("cursor","pointer");
					}
					if (current == "histogram" || current == "area") {//柱状图和面积图，独立时后两个都不可下拉
						if (tuArray[i] == "independent") {														
							$('.'+className+" .imgSetA:visible").removeAttr("onclick");
							$('.'+className+" .imgSetA:visible").css("cursor","auto");					
							$('.'+className+" .stackImg:visible").removeAttr("onclick");
							$('.'+className+" .stackImg:visible").css("cursor","auto");
						} else {
							$('.'+className+" .imgSetA:visible").attr("onclick","pullSet(this)");
							$('.'+className+" .imgSetA:visible").css("cursor","pointer");
							$('.'+className+" .stackImg:visible").attr("onclick","pullTiSt(this)");
							$('.'+className+" .stackImg:visible").css("cursor","pointer");
						}
					} 
					if (current == "pie") {
						if (tuArray[i] == "independent") {//	当第二个图标为独立时，第一、二个图标可下拉
		         			$("."+className+" .pie").attr("onclick","pullImg(this)");
		         			$("."+className+" .pie").css("cursor","pointer");
		         			$('.'+className+" .imgSetA:visible").attr("onclick","pullSet(this)");
							$('.'+className+" .imgSetA:visible").css("cursor","pointer");
					  	} else { //否则第一个不可下拉，第二个可下拉
				         		$("."+className+" .pie").removeAttr("onclick");
			         			$("."+className+" .pie").css("cursor","auto");
			         			$('.'+className+" .imgSetA:visible").attr("onclick","pullSet(this)");
								$('.'+className+" .imgSetA:visible").css("cursor","pointer");		         					         			
					    }
					}
				
				}
			//如果鼠标为箭头的显示，鼠标为小手的变灰
			beganToGray(Sort);
			//如果拉入的行列的字段太长时，省略
			omit(Sort);
			
}		
	function omit (Sort) {
		for (var i=0; i<Sort.length; i++) {
			if ($(Sort[i]).find(".pvtAttr").text().length>8) {			
				$(Sort[i]).find(".pvtAttr").css({"display":"block","width":"120px","overflow":"hidden","text-overflow":"ellipsis","white-space":"nowrap"});			
			}			
		}
	}
	function omitfield (element){
		$(element).css("width","auto");
	}

		function cleanImg() {
			$("#col li").find("img").hide();
			$("#row li").find("img").hide();
		}
		/*
		Heatmap post-processing
		 */
		$.fn.heatmap = function(scope) {
			var colorGen, heatmapper, i, j, l, n, numCols, numRows, ref, ref1;
			if (scope == null) {
				scope = "heatmap";
			}
			numRows = this.data("numrows");
			numCols = this.data("numcols");
			colorGen = function(color, min, max) {
				var hexGen;
				hexGen = (function() {
					switch (color) {
						case "red":
							return function(hex) {
								return "ff" + hex + hex;
							};
						case "green":
							return function(hex) {
								return hex + "ff" + hex;
							};
						case "blue":
							return function(hex) {
								return "" + hex + hex + "ff";
							};
					}
				})();
				return function(x) {
					var hex, intensity;
					intensity = 255 - Math.round(255 * (x - min) / (max - min));
					hex = intensity.toString(16).split(".")[0];
					if (hex.length === 1) {
						hex = 0 + hex;
					}
					return hexGen(hex);
				};
			};
			heatmapper = (function(_this) {
				return function(scope, color) {
					var colorFor, forEachCell, values;
					forEachCell = function(f) {
						return _this.find(scope).each(function() {
							var x;
							x = $(this).data("value");
							if ((x != null) && isFinite(x)) {
								return f(x, $(this));
							}
						});
					};
					values = [];
					forEachCell(function(x) {
						return values.push(x);
					});
					colorFor = colorGen(color, Math.min.apply(Math, values), Math.max.apply(Math, values));
					return forEachCell(function(x, elem) {
						return elem.css("background-color", "#" + colorFor(x));
					});
				};
			})(this);
			switch (scope) {
				case "heatmap":
					heatmapper(".pvtVal", "red");
					break;
				case "rowheatmap":
					for (i = l = 0, ref = numRows; 0 <= ref ? l < ref : l > ref; i = 0 <= ref ? ++l : --l) {
						heatmapper(".pvtVal.row" + i, "red");
					}
					break;
				case "colheatmap":
					for (j = n = 0, ref1 = numCols; 0 <= ref1 ? n < ref1 : n > ref1; j = 0 <= ref1 ? ++n : --n) {
						heatmapper(".pvtVal.col" + j, "red");
					}
			}
			heatmapper(".pvtTotal.rowTotal", "red");
			heatmapper(".pvtTotal.colTotal", "red");
			return this;
		};

		/*
		Barchart post-processing
		 */
		return $.fn.barchart = function() {
			var barcharter, i, l, numCols, numRows, ref;
			numRows = this.data("numrows");
			numCols = this.data("numcols");
			barcharter = (function(_this) {
				return function(scope) {
					var forEachCell, max, scaler, values;
					forEachCell = function(f) {
						return _this.find(scope).each(function() {
							var x;
							x = $(this).data("value");
							if ((x != null) && isFinite(x)) {
								return f(x, $(this));
							}
						});
					};
					values = [];
					forEachCell(function(x) {
						return values.push(x);
					});
					max = Math.max.apply(Math, values);
					scaler = function(x) {
						return 100 * x / (1.4 * max);
					};
					return forEachCell(function(x, elem) {
						var text, wrapper;
						text = elem.text();
						wrapper = $("<div>").css({
							"position": "relative",
							"height": "55px"
						});
						wrapper.append($("<div>").css({
							"position": "absolute",
							"bottom": 0,
							"left": 0,
							"right": 0,
							"height": scaler(x) + "%",
							"background-color": "gray"
						}));
						wrapper.append($("<div>").text(text).css({
							"position": "relative",
							"padding-left": "5px",
							"padding-right": "5px"
						}));
						return elem.css({
							"padding": 0,
							"padding-top": "5px",
							"text-align": "center"
						}).html(wrapper);
					});
				};
			})(this);
			for (i = l = 0, ref = numRows; 0 <= ref ? l < ref : l > ref; i = 0 <= ref ? ++l : --l) {
				barcharter(".pvtVal.row" + i);
			}
			barcharter(".pvtTotal.colTotal");
			return this;
		};
	});

}).call(this);
	//关闭下拉长框
	function closeBox (e) {
		$(e.offsetParent).hide();
	}
	
	function dropnode(nthis){
//		alert(3);
		$(nthis).parent().remove();
		setTimeout(function(){
			refreshExternal();
		},200);
	}
//# sourceMappingURL=pivot.js.map


//- jon


// console.log($('.imgSetSpan'))

console.log('嵌入');
$('.imgSetSpan').on('click', 'img', function () {
	console.log('llla')
})