;(function(undefined) {
    "use strict"
    var _global;
    var Cmd = {

		Alert:"alert",
		FadeInfo:"fadeInfo",
		OpenForm:"openForm",
		OpenMainForm:"openMainForm",
		CloseForm:"closeForm",
		DoCloseForm:"doCloseForm",
		
		RecordNew:"recordNew",
		RecordSave:"recordSave",
		RecordDelete:"recordDelete",
		RecordRestore:"recordRestore",

		WriteField:"writeField",
		DoWriteField:"doWriteField",
		WriteEditor:"writeEditor",
		DoWriteEditor:"doWriteEditor",
		WriteImage:"writeImage",
		
		RefreshPlugin:"refreshPlugin",
		
		ExecuteQuery:"executeQuery",
		FetchAll:"fetchAll",
		RestoreParent:"restoreParent",
		
		OpenURL:"openURL",
		OpenResource:"openResource",
		FormCmd:"formCmd",
		Js:"js",
		Npapi:"npapi",
		
		ShowDialog:"showDialog",
		
		UpdateControlVisible:"updateControlVisible",
		UpdateControlAllowEdit:"updateControlAllowEdit",
		UpdateControlLabel:"updateControlLabel",
		UpdateControlSkipTab:"updateControlSkipTab",
		UpdateGroupCollapseState:"updateGroupCollapseState",
		
		DS_AllowAdd:"ds_AllowAdd",
		DS_AllowDelete:"ds_AllowDelete",
		DS_AllowQuery:"ds_AllowQuery",
		DS_AllowSave:"ds_AllowSave",
		DS_AllowExport:"ds_AllowExport",
		DS_AllowAttachment:"ds_AllowAttachment",
		DS_AllowEdit:"ds_AllowEdit",
		
		TmpRecordAdd:"tmpRecordAdd",
		TmpRecordDelete:"tmpRecordDelete",
		TmpRecordRefresh:"tmpRecordRefresh",
		TmpRecordClear:"tmpRecordClear",
		
		SetControlProperty:"setControlProperty",
		SetFormDataSourceGroupProperty:"setFormDataSourceGroupProperty",
		
		UpdateQuery:"updateQuery",
		UpdateQueryForm:"updateQueryForm",
		UpdateQueryCurrent:"updateQueryCurrent",
		
		ActiveRecord:"activeRecord",
		
		ShowImage:"showImage",
		FileUpload:"fileUpload",
		FileDownload:"fileDownload",
		
		SetRecordConditionTask:"setRecordConditionTask",
		SetFormParamConditionTask:"setFormParamConditionTask",
		
		FocusIn:"focusIn",
		SwitchToTabPage:"switchToTabPage",
		
		ParentCmdResult:"parentCmdResult",
		LookupReturn:"lookupReturn",
		
		ClientRecordAdd:"clientRecordAdd",
		ClientRecordRemove:"clientRecordRemove",
		ClientRecordRefresh:"clientRecordRefresh",
		
		WriteDataMethodField:"writeDataMethodField",
		
		ShowClipboard:"showClipboard",
		
		RecordLocate:"locateRecord",
		
		ButtonOK:"buttonOk",
		
		ContextMap:"contextMap",
		
		UpdateEditorShowLookup:"updateEditorShowLookup",
		
		UpdateEditorShowMainForm:"updateEditorShowMainForm",
		
		OpenLookup:"openLookup",
		
		TimerStart:"createTimer",
		
		TimerStop:"cancelTimer",
		
		SelectRecords:"selectRecords",
		LocateToRecord:"locateToRecord",
		
		BindEditorStyle:"bindEditorStyle",
		BindRowStyle:"bindRowStyle",
		RemoveEditorStyle:"removeEditorStyle",
		RemoveRowStyle:"removeRowStyle",
		SetTextStyle:"setTextStyle",
		SetButtonStyle:"setButtonStyle",
		SetContainerStyle:"setContainerStyle",
		
		SetFormTitle:"setFormTitle",
		
		SysReinitForm:"sysReinitForm",
		
		DimSortFormItem:"dimSortFormItem",
		DimAdjustFormDataSourceField:"dimAdjustFormDataSourceField"

	}
	var CommandTask = function(){
		this.cmd = null;
		this.group = null;
		this.control = null;
		this.arg = null;
	};

	CommandTask.prototype.setGroup = function(groupAlias)
	{
		this.group = group;
		return this;
	}

	CommandTask.prototype.setControl = function(controlName)
	{
		this.control = controlName;
		return this;
	}
			
	CommandTask.prototype.setEditor = function(editorName)
	{
		this.control = editorName;
		return this;
	}
		
	CommandTask.prototype.setField = function(fieldName)
	{
		this.control = fieldName;
		return this;
	}
		
	CommandTask.prototype.setArg = function(arg)
	{
		this.arg = arg;
		return this;
	}

	var CommandResult = function(){
		this.tasks = [];
	};

	CommandResult.prototype.addTask=function()
	{
		var task = new CommandTask();
		var cmd = arguments[0];
		var arg = arguments.length>1?arguments[1]:null;
		task.cmd = cmd;task.arg = arg;
		this.tasks.push(task);
		return task;
	}

	CommandResult.prototype.alert=function(info){
		return this.addTask(Cmd.Alert).setArg(info);
	}

	CommandResult.prototype.fadeInfo=function(arg)
	{

		return this.addTask(Cmd.FadeInfo).setArg(arg);
	}

	CommandResult.prototype.openForm=function(openFormArg)
	{
		return this.addTask(Cmd.OpenForm).setArg(openFormArg);
	}

	CommandResult.prototype.openMainForm=function(openMainFormArg)
	{
		return this.addTask(Cmd.OpenMainForm).setArg(openMainFormArg);
	}

	CommandTask.prototype.closeForm=function()
	{
		return this.addTask(Cmd.CloseForm);
	}

	CommandResult.prototype.doCloseForm=function()
	{
		return this.addTask(Cmd.DoCloseForm);
	}

	CommandResult.prototype.recordNew=function()
	{
		return this.addTask(Cmd.RecordNew);
	}
	
	CommandResult.prototype.recordSave=function()
	{
		return this.addTask(Cmd.RecordSave);
	}
	
	CommandResult.prototype.recordDelete=function()
	{
		return this.addTask(Cmd.RecordDelete);
	}
	
	CommandResult.prototype.recordRestore=function()
	{
		return this.addTask(Cmd.RecordRestore).setArg(true);
	}
	
	CommandResult.prototype.doRecordRestore=function()
	{
		return this.addTask(Cmd.RecordRestore).setArg(false);
	}

	
	CommandResult.prototype.writeField=function()
	{
		if(arguments.length>1){
			var fieldName=arguments[0],value=arguments[1];
			// value = convertDateTime2String(fieldName, value);
			return this.addTask(Cmd.WriteField).setControl(fieldName).setArg(value);
		}else{
			var map=arguments[0];
			// map = convertDateTime2String(map);
			return this.addTask(Cmd.WriteField).setArg(map);
		}
	}
	
	CommandResult.prototype.doWriteField=function()
	{
		if(arguments.length>1){
			var fieldName=arguments[0],value=arguments[1];
			// value = convertDateTime2String(fieldName, value);
			return this.addTask(Cmd.DoWriteField).setControl(fieldName).setArg(value);	
		}else{
			var map=arguments[0];
			// map = convertDateTime2String(map);
			return this.addTask(Cmd.DoWriteField).setArg(map);		
		}
		
	}
	
	CommandResult.prototype.writeEditor=function()
	{
		if(arguments.length>1){
			var editorName=arguments[0],value=arguments[1];
			// value = convertDateTime2String(editorName, value);
			return this.addTask(Cmd.WriteEditor).setControl(editorName).setArg(value);
		}else{
			var map=arguments[0];
			// map = convertDateTime2String(map);
			return this.addTask(Cmd.WriteEditor).setArg(map);
		}
	}
	
	CommandResult.prototype.doWriteEditor=function()
	{
		if(arguments.length>1){
			var editorName=arguments[0],value=arguments[1];
			// value = convertDateTime2String(editorName, value);
			return this.addTask(Cmd.DoWriteEditor).setControl(editorName).setArg(value);	
		}else{
			var map=arguments[0];
			// map = convertDateTime2String(map);
			return this.addTask(Cmd.DoWriteEditor).setArg(map);
		}
		
	}
	
	CommandResult.prototype.writeImage=function()
	{
		if(arguments.length>1){
			var controlName=arguments[0],path=arguments[1];
			return this.addTask(Cmd.WriteImage).setControl(controlName).setArg(path);
		}else{
			var map=arguments[0];
			return this.addTask(Cmd.WriteImage).setArg(map);
		}
	}
	
	
	CommandResult.prototype.refreshPlugin=function(pluginName,value)
	{
		return this.addTask(Cmd.RefreshPlugin).setControl(pluginName).setArg(value);		
	}
	
	CommandResult.prototype.refreshPlugin_Tree=function(pluginName, treeRefreshArg)
	{
		return this.addTask(Cmd.RefreshPlugin).setControl(pluginName).setArg(treeRefreshArg);		
	}
	
	CommandResult.prototype.refreshPlugin_Radio=function(pluginName,radioRefreshArg)
	{
		return this.addTask(Cmd.RefreshPlugin).setControl(pluginName).setArg(radioRefreshArg);
	}
	

	CommandResult.prototype.refreshPlugin_Html=function(pluginName,htmlRefreshArg)
	{
		return this.addTask(Cmd.RefreshPlugin).setControl(pluginName).setArg(htmlRefreshArg);
	}
	
	/**
	 * 模拟客户端操作，执行查询
	 * @return
	 */
	CommandResult.prototype.executeQuery=function()
	{
		return this.addTask(Cmd.ExecuteQuery);
	}
	
	/**
	 * 模拟客户端操作，执行查询全体
	 * @return
	 */
	CommandResult.prototype.fetchAll=function()
	{
		return this.addTask(Cmd.FetchAll);
	}

	/**
	 * 恢复父级数据源的当前记录，并触发其子数据源的重新查询
	 * @return
	 */
	CommandResult.prototype.restoreParent=function()
	{
		return this.addTask(Cmd.RestoreParent).setArg(true);
	}
	
	/**
	 * 恢复父级数据源的当前记录，但不触发其子数据源的重新查询
	 * @return
	 */
	CommandResult.prototype.doRestoreParent=function()
	{
		return this.addTask(Cmd.RestoreParent).setArg(false);
	}
	
	/**
	 * 用于打开服务端GongqiERP目录下的resource文件或者tmp文件， 在浏览器中新打开一个网页指向该路径或者直接下载
	 * @param path 格式为*或者@tmp/*，不要带账套名，例如：attachments/30000002/10934/test.jpg、@tmp/a.html
	 * @return
	 */
	CommandResult.prototype.openResource=function(path)
	{
		return this.addTask(Cmd.OpenResource).setArg(path);
	}
	
	/**
	 * 在浏览器中新打开一个网页指向该地址
	 * @param openURLArg 相对于客户端html目录下的相对路径，或者http://、https://开头的绝对路径，可以携带参数
	 * @return
	 */

	
	CommandResult.prototype.openURL=function(arg)
	{
		if(typeof arg=='string')
			arg=new OpenURLArg(args);
		
		return this.addTask(Cmd.OpenURL).setArg(arg);
	}
	
	
	
	/**
	 * 执行画面的服务端二次开发方法
	 * @param methodName 方法名称
	 * @return
	 */ 
	CommandResult.prototype.formCmd=function()
	{
		if (arguments.length>1) {
			var methodName=arguments[0];
			var methodArg=arguments[1];
			var map={
				methodName:methodName,
				methodArg:methodArg
			};
			return this.addTask(Cmd.FormCmd).setArg(map);
		}else{
			var methodName=arguments[0];
			return this.addTask(Cmd.FormCmd).setArg(methodName);
			
		}
	}

	
	/**
	 * 执行js语句
	 * @param jsCode js语句
	 * @return
	 */
	CommandResult.prototype.js=function(jsCode)
	{
		return this.addTask(Cmd.Js).setArg(jsCode);
	}
	
	/**
	 * 更新画面元素的Visible值
	 * @param controlName 画面元素名称
	 * @param visible  Visible值
	 * @return
	 */
	CommandResult.prototype.updateControlVisible=function()
	{
		if(arguments.length>1){
			var controlName=arguments[0],visible=arguments[1];
			return this.addTask(Cmd.UpdateControlVisible).setControl(controlName).setArg(visible);
		}else{
			var map=arguments[0];
			return this.addTask(Cmd.UpdateControlVisible).setArg(map);	
		}
		
	}
	
	
	/**
	 * 更新画面元素的AllowEdit值
	 * @param controlName 画面元素名称
	 * @param allowEdit AllowEdit值
	 * @return
	 */
	CommandResult.prototype.updateControlAllowEdit=function()
	{
		if(arguments.length>1){
			var controlName=arguments[0]
			var allowEdit=arguments[1];
			return this.addTask(Cmd.UpdateControlAllowEdit).setControl(controlName).setArg(allowEdit);	
		}else{
			var map=arguments[0];
			return this.addTask(Cmd.UpdateControlAllowEdit).setArg(map);
		}
		
	}
	
	
	/**
	 * 更新画面元素的Label值
	 * @param controlName 画面元素名称
	 * @param label Label值
	 * @return
	 */
	CommandResult.prototype.updateControlLabel=function()
	{
		if (arguments.length>1) {
			var controlName=arguments[0];
			var label=arguments[1];
			return this.addTask(Cmd.UpdateControlLabel).setControl(controlName).setArg(label);	
		}else{
			var map=arguments[0];
			return this.addTask(Cmd.UpdateControlLabel).setArg(map);
		}
		
	}
	
	/**
	 * 更新画面元素的SkipTab值
	 * @param controlName 画面元素名称
	 * @param skipTab SkipTab值
	 * @return
	 */
	CommandResult.prototype.updateControlSkipTab=function()
	{
		if(arguments.length>1){
			var controlName=arguments[0];
			var skipTab=arguments[1];
			return this.addTask(Cmd.UpdateControlSkipTab).setControl(controlName).setArg(skipTab);
		}else{
			var map=arguments[0];
			return this.addTask(Cmd.UpdateControlSkipTab).setArg(map);
		}
		
	}
	
	/**
	 * 更改画面元素（Group类型，且必须在GOT中设置为可折叠）的折叠状态
	 * @param controlName 画面元素名称
	 * @param open 是否打开
	 * @return
	 */
	CommandResult.prototype.updateGroupCollapseState=function(controlName,open)
	{
		return this.addTask(Cmd.UpdateGroupCollapseState).setControl(controlName).setArg(open);
		
	}
	
	/**
	 * 更新数据源的AllowAdd值
	 * @param allowAdd
	 * @return
	 */
	CommandResult.prototype.ds_AllowAdd=function(allowAdd)
	{
		return this.addTask(Cmd.DS_AllowAdd).setArg(allowAdd);
	}
	
	/**
	 * 更新数据源的AllowDelete值
	 * @param allowDelete
	 * @return
	 */
	CommandResult.prototype.ds_AllowDelete=function(allowDelete)
	{
		return this.addTask(Cmd.DS_AllowDelete).setArg(allowDelete);
	}
	
	/**
	 * 更新数据源的AllowQuery值
	 * @param allowQuery
	 * @return
	 */
	CommandResult.prototype.ds_AllowQuery=function(allowQuery)
	{
		return this.addTask(Cmd.DS_AllowQuery).setArg(allowQuery);
	}
	
	/**
	 * 更新数据源的AllowSave值
	 * @param allowSave
	 * @return
	 */
	CommandResult.prototype.ds_AllowSave=function(allowSave)
	{
		return this.addTask(Cmd.DS_AllowSave).setArg(allowSave);
	}
	
	/**
	 * 更新数据源的AllowExport值
	 * @param allowExport
	 * @return
	 */
	CommandResult.prototype.ds_AllowExport=function(allowExport)
	{
		return this.addTask(Cmd.DS_AllowExport).setArg(allowExport);
	}
	
	/**
	 * 更新数据源的AllowAttachment值
	 * @param allowAttachment
	 * @return
	 */
	CommandResult.prototype.ds_AllowAttachment=function(allowAttachment)
	{
		return this.addTask(Cmd.DS_AllowAttachment).setArg(allowAttachment);
	}
	
	/**
	 * 更新数据源的AllowEdit值
	 * @param allowEdit
	 * @return
	 */
	CommandResult.prototype.ds_AllowEdit=function(allowEdit)
	{
		return this.addTask(Cmd.DS_AllowEdit).setArg(allowEdit);
	}
	
	/**
	 * 给临时表添加多条记录
	 * @param records
	 * @return
	 */
	CommandResult.prototype.tmpRecordAdd=function(records)
	{
		return this.addTask(Cmd.TmpRecordAdd).setArg(records);
	}
	
	CommandResult.prototype.tmpRecordRefresh=function(records)
	{
		return this.addTask(Cmd.TmpRecordRefresh).setArg(records);
	}
	
	/**
	 * 清空临时表
	 * @return
	 */
	CommandResult.prototype.tmpRecordClear=function()
	{
		return this.addTask(Cmd.TmpRecordClear);
	}
	
	
	/**
	 * @param groupAlias 数据源的alias
	 * @param propetyName 属性名称，可引用自FormDataSourceGroupPropertyArg
	 * @param value 值
	 * @return
	 */
	CommandResult.prototype.setFormDataSourceGroupProperty=function(groupAlias,propetyName,value)
	{
		var map={};
		map[propetyName]=value;
		return this.addTask(Cmd.SetFormDataSourceGroupProperty).setGroup(groupAlias).setArg(map);
	}
	
	/**
	 * 主动触发客户端的activeRecord事件
	 * @return
	 */
	CommandResult.prototype.activeRecord=function()
	{
		return this.addTask(Cmd.ActiveRecord);
	}
	
	/**
	 * 显示图片
	 * @param path 首先找对应@name的FormItem_Image，如果存在则显示其图片，如果不存在则按服务端文件路径显示图片
	 * @return
	 */
	CommandResult.prototype.showImage=function(path)
	{
		return this.addTask(Cmd.ShowImage).setArg(path);
	}
	
	/**
	 * 上传文件到指定路径
	 * @param url 相对于GongqiERP目录下的resource目录，包含文件名的描述
	 * @return
	 */
	 CommandResult.prototype.fileUpload=function()
	 {
	 	if(arguments.length>1){
	 		var arg= new FileUploadArg(arguments[0],arguments[1],arguments[2]);
	 	}else{
	 		var arg = new FileUploadArg(arguments[0]);
	 		
	 	}
	 	return this.addTask(Cmd.FileUpload).setArg(arg);
	 }

	
	/**
	 * 从指定路径下载文件
	 * @param url 相对于GongqiERP下的resource目录而言
	 * @return
	 */
	CommandResult.prototype.fileDownload=function(url)
	{
		return this.addTask(Cmd.FileDownload).setArg(url);
	}
	
	/**
	 * 将焦点定位到指定的control，如果该control不可见，则不做任何处理
	 * 仅适用于Editor、DataGrid、Button、ButtonMenu、MenuItemButton
	 * @param controlName
	 * @return
	 */
	CommandResult.prototype.focusIn=function(controlName)
	{
		return this.addTask(Cmd.FocusIn).setControl(controlName);
	}
	
	/**
	 * 切换到指定的TabPage，如果该TabPage不可见，则不做任何处理
	 * @param tabPageName
	 * @return
	 */
	CommandResult.prototype.switchToTabPage=function(tabPageName)
	{
		return this.addTask(Cmd.SwitchToTabPage).setControl(tabPageName);
	}
	
	/**
	 * 一、对于自定义的下拉画面，执行其主画面的客户端命令集，只有当其主画面为FormModule时才执行
	 * 二、对于普通的画面，执行其父画面的客户端命令集，如果其父画面不存在则不做任何处理
	 * @param commandResult
	 * @return
	 */
	CommandResult.prototype.parentCmdResult=function(commandResult)
	{
		return this.addTask(Cmd.ParentCmdResult).setArg(commandResult);
	}
	
	/**
	 * 在客户端数据源中移除对应recId的记录
	 * @param recId
	 * @return
	 */
	CommandResult.prototype.clientRecordRemove=function(recId)
	{
		return this.addTask(Cmd.ClientRecordRemove).setArg(recId);
	}
	
	CommandResult.prototype.writeDataMethodField=function(map)
	{
		var tmp;
		if(map==null)
		{
			tmp=null;
		}else
		{
			tmp={};
			for(var key in map)
			{
				tmp[key+'']=map[key];
			}
		}
		
		return this.addTask(Cmd.WriteDataMethodField).setArg(tmp);
	}
	
	
	/**
	 * 模拟客户端操作，点击按钮
	 * @param buttonName
	 * @return
	 */
	CommandResult.prototype.buttonOK=function(buttonName)
	{
		return this.addTask(Cmd.ButtonOK).setControl(buttonName);
	}

	
	
	/**
	 * 选择指定记录
	 * @param recIds， 当前画面上现有数据的recId的集合
	 * @return
	 */
	CommandTask.prototype.selectRecords=function(recIds)
	{
		return this.addTask(Cmd.SelectRecords).setArg(recIds);
	}
	
	/**
	 * 设置画面的标题
	 * @param title 标题。 如果传入null，则不改变当前标题。
	 * @return
	 */
	CommandResult.prototype.setFormTitle=function(title)
	{
		return this.addTask(Cmd.SetFormTitle).setArg(title);
	}
	
	
    //CommandResult对象暴露给全局对象
    _global = (function(){ return this || (0, eval)('this'); }());
    if (typeof module !== "undefined" && module.exports) {
        module.exports = CommandResult;
    } else if (typeof define === "function" && define.amd) {
        define(function(){return CommandResult;});
    } else {
        !('CommandResult' in _global) && (_global.CommandResult = CommandResult);
    }
}());

var FadeInfoArg = function(){
	this.label= "";
	this.center= true;
	this.duration= 1500;
	this.pause= 1000;
	this.labelColor = 0x000000;
	this.bgColor = 0xF2F2F2;
	this.cornerRadius = 7;
};

var OpenFormArg=function(){
	this.menuItemId='';
	this.callerKey= null;
		
	this.paramString='';
	this.paramObject='';
		
		
	this.enterMainForm = false;
	this.mainFormWhereValues = [];
		
		
		
		//优先级高
	this.addFixedGroupRelation = false;
	this.linkGroupAlias = '';
		//优先级低
	this.addAutoGroupRelation = false;
		
		
	this.isPopUp = false;
}

var OpenMainFormArg=function(){
	this.menuItemId='';
	this.paramString='';
	this.mainFormWhereValues=[];
}

var TreeRefreshArg=function(){
	this.opr='';
	this.arg={};
	this.SET_DATA ="SET_DATA";
	this.SET_ICONS ="SET_ICONS";
	this.ADD_NODE ="ADD_NODE";
	this.DELETE_NODE ="DELETE_NODE";
	this.SELECT_NODE ="SELECT_NODE";
}


var RadioRefreshArg=function(){
	this.opr = '';
	this.arg = {};
}

var HtmlRefreshArg=function(){
	this.CHANGE_URL="changeURL";
	this.CALL_IFRAME_METHOD ="callIFrameMethod";
		
	this.opr ='';
		
	this.iframeFuncArg=[];

	this.arg = {};
		
	this.addClientInfo = false;
}

var OpenURLArg=function(){
	this.url ='';
	this.parameters='';//同MenuItem上的Parameters
		
}


var FileUploadArg=function(){
	this.url ='';
	this.title ='';
	this.info ='';
}
var FormCmdArgObject=function(){

}

var FormDataSourceGroupArg=function(){
	this.argType=null;
	this.groupAlias='';
	this.aliasList=[];
	this.arg={};
	this.recordCounts=0;
}


var FormDataSourceGroupResult =function(){
	this.groupAlias='';
	this.aliasList=null;
	this.dataResult={};
	this.recordCounts=null;
	this.maxCounts = -1;	//-1表示未知
	this.commandResult=null;
	this.autoSaveRecord= true;
}

function callCommandResult(result)
{
	if(window.parent.window.isH5)
	{
		window.parent.window.exeCommandResult(result);
	}
	else
	{
		var parentFrameID = self.frameElement.getAttribute("id");
		parent.callCommandResult(parentFrameID,result.tasks);
	}
}

