function drawCanvas(data, drawCanvas) {
  let list = []
  data.forEach(item => {
    if (item.shape === 'org-node') {
      // item.attrs.body.stroke = '#fff'
      item.attrs.body.fill = '#fff'
      item.ports.groups.top.attrs.circle.r = 0
      item.ports.groups.bottom.attrs.circle.r = 0
      item.ports.groups.left.attrs.circle.r = 0
      item.ports.groups.right.attrs.circle.r = 0
    }
    list.push(item)
  })
  const graph = new X6.Graph({
    container: document.getElementById('content'),
    grid: false,
    selecting: false,
    panning: false,
    width: "100vw",
    height: "100vh",
    scroller: {
      enabled: true,
      pannable: true
    },
    interacting: {
      nodeMovable: false
    }
  })
  X6.Graph.registerNode(
    'org-node',
    {
      width: 130,
      height: 82,
      markup: [
        {
          tagName: 'rect',
          selector: 'body',
        },
        {
          tagName: 'image',
          selector: 'avatar',
        },
        {
          tagName: 'text',
          selector: 'name',
        },
        {
          tagName: 'text',
          selector: 'explain'
        }
      ],
      attrs: {
        body: {
          refWidth: '100%',
          refHeight: '100%',
          fill: '#ccc',
          // stroke: '#ccc',
          strokeWidth: 2,
          rx: 10,
          ry: 10,
          pointerEvents: 'visiblePainted',
          cursor: 'pointer',
          filter: {
            name: 'dropShadow',
            args: {
              color: '#ccc',
              dx: 0,
              dy: 0,
              blur: 6,
              opacity: 0.5
            }
          }
        },
        avatar: {
          // refX: '50%',
          // refY: 15,
          text: '\ue631',
          fill: '#696969',
          fontSize: 40,
          fontFamily: 'iconfont',
          textAnchor: 'middle',
          refX: '35%',
          refY: -20,
          width: '40px',
          height: '40px',
          cursor: 'pointer',
          'xlink:href': require('../../src/assets/img/box.png'),
        },
        name: {
          refX: '50%',
          refY: 62,
          fontFamily: 'Courier New',
          fontSize: 14,
          fontWeight: '800',
          textAnchor: 'middle',
          cursor: 'pointer'
        },
        explain: {
          refX: '50%',
          refY: 80,
          fontFamily: 'Courier New',
          fontSize: 12,
          fontWeight: '500',
          textAnchor: 'middle',
          cursor: 'pointer'
        }
      }
    },
    true,
  )
  // graph.on("node:mouseenter",({ cell }) => {
  //   cell.attr("body/stroke", '#2d8cf0');
  // })
  // graph.on("node:mouseleave", ({ cell }) => {
  //   cell.attr("body/stroke", '#fff');
  // });
  graph.on("node:click", ({ cell }) => {
    if (top.location != location) {
      window.parent.window.openForm({
        menuItemId: cell.store.data.attrs.name.id,
        onlyQuery: false,
        label: cell.store.data.attrs.name.text,
        checkHas: false,
        fromMainMenu: true
      })
    }
  })
  graph.fromJSON(list)
  graph.centerContent()
  graph.drawBackground({
    image: drawCanvas,
    position: 'center',
    size: 'auto auto',
  })
  //graph.disableSelection()
}
