/* Author：mingyuhisoft@163.com
 * Github:https://github.com/imingyu/jquery.mloading
 * Npm:npm install jquery.mloading.js
 * Date：2016-7-4
 */

;(function (root, factory) {
    'use strict';

    if (typeof module === 'object' && typeof module.exports === 'object') {
        factory(require('jquery'),root);
    } if(typeof define ==="function"){
        if(define.cmd){
            define(function(require, exports, module){
                var $ = require("jquery");
                factory($,root);
            });
        }else{
            define(["jquery"],function($){
                factory($,root);
            });
        }
    }else {
        factory(root.jQuery,root);
    }
} (typeof window !=="undefined" ? window : this, function ($, root, undefined) {
    'use strict';
    if(!$){
        $ = root.jQuery || null;
    }
    if(!$){
        throw new TypeError("必须引入jquery库方可正常使用！");
    }

    var arraySlice = Array.prototype.slice,
        comparison=function (obj1,obj2) {
            var result=true;
            for(var pro in obj1){
                if(obj1[pro] !== obj2[obj1]){
                    result=true;
                    break;
                }
            }
            return result;
        }

    function MLoading(dom,options) {
        options=options||{};
        this.dom=dom;
        this.options=$.extend(true,{},MLoading.defaultOptions,options);
        this.curtain=null;
        this.render().show();
    }
    MLoading.prototype={
        constructor:MLoading,
        initElement:function () {
            var dom=this.dom,
                ops=this.options;
            var curtainElement=dom.children(".mloading"),
                bodyElement = curtainElement.children('.mloading-body'),
                barElement = bodyElement.children('.mloading-bar'),
                iconElement = barElement.children('.mloading-icon'),
                textElement = barElement.find(".mloading-text");
            if (curtainElement.length == 0) {
                curtainElement = $('<div class="mloading"></div>');
                dom.append(curtainElement);
            }
            if (bodyElement.length == 0) {
                bodyElement = $('<div class="mloading-body"></div>');
                curtainElement.append(bodyElement);
            }
            if (barElement.length == 0) {
                barElement = $('<div class="mloading-bar"></div>');
                bodyElement.append(barElement);
            }
            if (iconElement.length == 0) {
                var _iconElement=document.createElement(ops.iconTag);
                iconElement = $(_iconElement);
                iconElement.addClass("mloading-icon");
                barElement.append(iconElement);
            }
            if (textElement.length == 0) {
                textElement = $('<span class="mloading-text"></span>');
                barElement.append(textElement);
            }
            
            this.curtainElement=curtainElement;
            this.bodyElement = bodyElement;
            this.barElement = barElement;
            this.iconElement = iconElement;
            this.textElement = textElement;
            return this;
        },
        render:function () {
            var dom=this.dom,
                ops=this.options;
            this.initElement();
            if(dom.is("html") || dom.is("body")){
                this.curtainElement.addClass("mloading-full");
            }else{
                this.curtainElement.removeClass("mloading-full");

                if(!dom.hasClass("mloading-container")){
                    dom.addClass("mloading-container");
                }
            }
            if(ops.mask){
                this.curtainElement.addClass("mloading-mask");
            }else{
                this.curtainElement.removeClass("mloading-mask");
            }
            if(ops.content!="" && typeof ops.content!="undefined"){
                if(ops.html){
                    this.bodyElement.html(ops.content);
                }else{
                    this.bodyElement.text(ops.content);
                }
            }else{
                this.iconElement.attr("src",ops.icon);
                if(ops.html){
                    this.textElement.html(ops.text);
                }else{
                    this.textElement.text(ops.text);
                }
            }

            return this;
        },
        setOptions:function (options) {
            options=options||{};
            var oldOptions = this.options;
            this.options = $.extend(true,{},this.options,options);
            if(!comparison(oldOptions,this.options)) this.render();
        },
        show:function () {
            var dom=this.dom,
                ops=this.options,
                barElement=this.barElement;
            this.curtainElement.addClass("active");
            barElement.css({
                "marginTop":"-"+barElement.outerHeight()/2+"px",
                "marginLeft":"-"+barElement.outerWidth()/2+"px"
            });

            return this;
        },
        hide:function () {
            var dom=this.dom,
                ops=this.options;
            this.curtainElement.removeClass("active");
            if(!dom.is("html") && !dom.is("body")){
                dom.removeClass("mloading-container");
            }
            return this;
        },
        destroy:function () {
            var dom=this.dom,
                ops=this.options;
            this.curtainElement.remove();
            if(!dom.is("html") && !dom.is("body")){
                dom.removeClass("mloading-container");
            }
            dom.removeData(MLoading.dataKey);
            return this;
        }
    };
    MLoading.dataKey="MLoading";
    MLoading.defaultOptions = {
        text:"加载中...",
        iconTag:"img",
        icon:"data:image/gif;base64,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",
        html:false,
        content:"",//设置content后，text和icon设置将无效
        mask:true//是否显示遮罩（半透明背景）
    };

    $.fn.mLoading=function (options) {
        var ops={},
            funName="",
            funArgs=[];
        if(typeof options==="object"){
            ops = options;
        }else if(typeof options ==="string"){
            funName=options;
            funArgs = arraySlice.call(arguments).splice(0,1);
        }
        return this.each(function (i,element) {
            var dom = $(element),
                plsInc=dom.data(MLoading.dataKey);
            if(!plsInc){
                plsInc=new MLoading(dom,ops);
            }

            if(funName){
                var fun = plsInc[funName];
                if(typeof fun==="function"){
                    fun.apply(plsInc,funArgs);
                }
            }
        });
    }
}));